#!/usr/bin/env python2
# -*- coding: UTF-8 -*-

# For Linux and OSX, don't forget the "shebang" in the first line. The "/usr/bin/env python2" form
# is prefered over the more direct "/usr/bin/python"

# The "coding" comment above is important if you use any non ASCII characters, even in your comments.
# Of course it should match the actual encoding used by your code editor (on Linux, UTF-8 is usually the
# default)

import traceback
from gimpfu import *

# Example typical code that takes an image and a drawable
def theCode(theImage,theDrawable):
    
    # Bracketing the code in an "undo group" makes it easy to undo the 
    # script actions in a single Ctrl-Z (otherwise it is one Ctrl-Z
    # per script action which can be long-winded
    theImage.undo_group_start()
    
    # Likewise you can save the context (active colors, brushes, fonts,..)
    # and restore it when the script ends so that the user's environment
    # isn't disturbed by your script
    gimp.context_push()

    try:
        # Your actual plugin code is executed inside a try/except block
        # So any mishap is caught and the script exits cleanly
        # A perk of this technique is that you can exit the script
        # from any level of call by just raising an exception.
        if not isinstance(theDrawable,gimp.Layer):
            raise Exception("This script only works on layers")
        if isinstance(theDrawable,gimp.GroupLayer):
            raise Exception("This script doesn't work on layer groups")
                              
        pdb.gimp_message('Running on image "%s" (%d) on drawable "%s"' \
            % (theImage.name,theImage.ID,theDrawable.name))
    
    except Exception as e:
        # Give the exception message to the user (pop up dialog or error console)
        pdb.gimp_message(e.args[0])
        # Print a stack trace for you in the terminal or gimp-console
        print traceback.format_exc()
    
    # Due to try/except the code always ends up here so it can cleanup things
    
    # Restore the context
    gimp.context_pop()
    # Mark the end of the undo grouo
    theImage.undo_group_end()
    return

# The registration code. Evertyhin is "hard-coded" here but specific bits can be put in 
# variables, for instance to avodiu duplication if you register several related plug-ins in the
# same Python file.

authorsName="John H. Doe Jr" 

register(
    # The plugin identifier. It should be unique across all installed plugins
    # So it is a good idea to start the name with a prefix of your own 
    # ("pfx-" in this example, mine is "ofn-")
	'pfx-plugin-identifier',
	
	'Example registration of a python plugin (short description, pops up in menus)',
	
	'''
Example registration of a python plugin (long-winded help that shows in the PDB browser).
	
This can easily be made to run on several lines or even whole paragraphs if you use Python's triple-quote strings.
	
This is mostly intended for other coders calling your script from their own so don't overdo it. Regular users may prefer a simple doc with images and examples.
	''', 
	
	# Variable used to avoid discrepancy
	authorsName,"©"+authorsName,'2024',
	
	'Test menu item',
	
	'*', # works on all image types
	
	# Descriptions of script arguments, from which Gimp creates the script dialog
	# If the first argument is a PF_IMAGE, it is assumed to be the active image
	# If the second argument is a PF_DRAWABLE, it is assumed to be the active drawable 
	# (active layer, layer mask, layer group, channel). 
	# So of course the script dialog doesn't include them and if these are the
	# only arguments the script is called directly without showing a dialog. 
	# You may also notice that the PDB browser document a "run-mode" argument
	# to you script. In Python this argument is actually hidden and appears
	# as an optional `run_mode` keyword argument
	[
        (PF_IMAGE, "image", "Input image", None),           # Active image if called from the UI
        (PF_DRAWABLE, "drawable", "Input drawable", None),  # Active drawable if called from the UI
        # Other parameters would come here
    ],
    
    # If your script creates image/layers or other objects and you want to be really nice,
    # you can have your script code return them, and describe their type here. 
    # Makes it easier for other scripts calling your script.    
	[],
	
	# The function that implements the plugin. 
	# It shoud accept exactly as many arguments as you have declared above
	theCode,
	
	# The menu in which the script appears. The is the "modern" form and when used
	# the handling of the first two Image/Layer arguments is as described above.
	menu='<Image>/Test/',
)

main()

