#!/usr/bin/env python
# -*- coding: utf-8 -*-

# v6a
#    Solved error with rotation
#    Unified defs ShapeRect and ShapeQuad, the external shape ShapeRect deleted
# v6b
#    solved error with rectangles
#    added minimal value for shape options
#    sorted list of shapes
#    new shapes: star sllipse, polygon ellipse
# v6c
#    No more Square and Circle shapes, check the option Squared selection from Selection tab
#    for get square and circle of rectangle and ellipse
#  v8
#    New internal method for plugins, more flexible interface, added drawings, checkboxes, radio buttons
#    Categorized plugins by theme, circular, foldables, etc
#    New shapes: moon, foldables (box, letter envelope), cloud,two arches, radial ruler

import gimp, gimpplugin, math,random
from gimpenums import *
pdb = gimp.pdb
import gtk, gimpui

useCollections=True
try:
	__import__('collections')
except ImportError:
	useCollections=False
else:
	import collections
	
import gimpshelf, os, sys, gettext

from __main__ import *
from math import *

p=os.path.dirname(sys.argv[0]) + os.sep +'locales'
shapesImgPath=os.path.dirname(sys.argv[0]) + os.sep +'shapesImg'+ os.sep


#include fix ---------------------------------------------------
class pnt2d(object):
	def __init__(self,x=0.0,y=0.0):
		self.x = x
		self.y = y
		return
	def __eq__(self, other):
		if self is None or other is None:
			return False
		elif self.x==other.x and self.y==other.y:
			return True
		else:
			return False
	def translate(self,x,y):
		self.x += x
		self.y += y
		return self
	def scale(self,x=1.0,y=1.0):
		self.x *= x
		self.y *= y
		return self
	def rotate(self,rot,cX=0.0,cY=0.0):
		px = cX + (self.x-cX) * math.cos(rot) - (self.y-cY)*math.sin(rot)
		py = cY + (self.x-cX) * math.sin(rot) + (self.y-cY)*math.cos(rot)
		self.x=px
		self.y=py
		return self
	def rotdeg(self,rot,cX=0.0,cY=0.0):
		self.rotate(math.radians(rot),cX,cY)
		return self

	def skew(self,rotX,rotY,cX=0.0,cY=0.0):
		#P' = (x + (y – py)tanT, y + (x – px)tanF)
		x,y=(self.x + (self.y-cY)*math.tan(math.radians(rotX)), self.y + (self.x-cX)*math.tan(math.radians(rotY)))
		self.x=x
		self.y=y
		return self
	def copy(self,pnt):
		self.x=pnt.x
		self.y=pnt.y
		return self
	def arrXY(self,tot=1):
		return [self.x,self.y]*tot
	def xy(self,tot=1):
		return (self.x,self.y)
	def length(self):
		return math.sqrt(self.x * self.x + self.y * self.y)

class bezpnt(object):
	def __init__(self,pfixed=None,pprev=None,pnext=None):
		if isinstance(pfixed, list):
			self.fixed = pnt2d(pfixed[0],pfixed[1])
		else:
			self.fixed = pfixed
		if isinstance(pprev, list):
			self.prev = pnt2d(pprev[0],pprev[1])
		else:
			self.prev = pprev
		if isinstance(pnext, list):
			self.next = pnt2d(pnext[0],pnext[1])
		else:
			self.next = pnext
		return
	def translate(self,x,y):
		self.fixed.translate(x,y)
		if self.prev!=None:self.prev.translate(x,y)
		if self.next!=None:self.next.translate(x,y)
		return self
	def scale(self,x=1.0,y=1.0):
		self.fixed.scale(x,y)
		if self.prev!=None:self.prev.scale(x,y)
		if self.next!=None:self.next.scale(x,y)
		return self
	def rotate(self,rot,cX=0.0,cY=0.0):
		self.fixed.rotate(rot,cX,cY)
		if self.prev!=None:self.prev.rotate(rot,cX,cY)
		if self.next!=None:self.next.rotate(rot,cX,cY)
		return self
	def skew(self,rotx,roty,cX=0.0,cY=0.0):
		self.fixed.skew(rotx,roty,cX,cY)
		if self.prev!=None:self.prev.skew(rotx,roty,cX,cY)
		if self.next!=None:self.next.skew(rotx,roty,cX,cY)
		return self
	def copy(self,bez2):
		try:
			self.fixed=pnt2d().copy(bez2.fixed)
			self.prev = None if bez2.prev == None else pnt2d().copy(bez2.prev)
			self.next = None if bez2.next == None else pnt2d().copy(bez2.next)
		except Exception,e:
			gimp.message(str(e))
		return self
	def arrXY(self):
		pts=[]
		if self.prev == None:
			pts+=self.fixed.arrXY(1)
		else:
			pts+=self.prev.arrXY(1)
		pts+=self.fixed.arrXY(1)
		if self.next==None:
			pts+=self.fixed.arrXY(1)
		else:
			pts+=self.next.arrXY(1)
		return pts
	def Prev(self):
		p = self.prev
		if p==None: p=self.fixed
		return p
	def Next(self):
		p = self.next
		if p==None: p=self.fixed
		return p
	def Fixed(self):
		return self.fixed
	def flip(self):
		p=self.prev
		n=self.next
		self.prev=n
		self.next=p

class gimppath(object):
	def __init__(self,pts=None):
		self.bpoints=[]
		if pts != None: self.bpoints=pts
		return
	def translate(self,x,y):
		for b in self.bpoints: b.translate(x,y)
		return self
	def scale(self,x=1.0,y=1.0):
		for b in self.bpoints: b.scale(x,y)
		return self
	def rotate(self,rot,cX=0.0,cY=0.0):
		for b in self.bpoints: b.rotate(rot, cX, cY)
		return self
	def skew(self,rotX,rotY,cX=0.0,cY=0.0):
		for b in self.bpoints: b.skew(rotX,rotY,cX,cY)
		return self
	def rotdeg(self,rot,cX=0.0,cY=0.0):
		self.rotate(math.radians(rot),cX,cY)
		return self
	def append(self,arr):
		self.bpoints.append(arr)
	def toGimpPath(self):
		arrG=[]
		for b in self.bpoints: arrG.extend(b.arrXY())
		return arrG
	def len(self):
		return len(self.bpoints)
	def getBezAt(self,num):
		return self.bpoints[num]
	def compact(self):
		bps=self.bpoints
		for n in range(self.len()-1,1,-1):
			# si este y el anterior comparten dos puntos los unimos y eliminamos este
			b2=bps[n]
			b3=None
			b1=bps[n-1]
			if b2.fixed==b1.fixed and b2.prev==b1.next:
				if b2.next!=None: b3=pnt2d().copy(b2.next)
				b1.next=b3
				del bps[n]
		self.bpoints=bps
		return self
	def getFromStroke(self,st):
		#v[0].strokes[0].points
		for n in range(len(st)/6):
			nn=n*6
			bp=bezpnt(pnt2d(st[nn+2],st[nn+3]),pnt2d(st[nn],st[nn+1]),pnt2d(st[nn+4],st[nn+5]))
			self.append(bp)
		return self
#-----------------------------------------------------

def defIndex(arr,index,alt=None):
	if len(arr)>index:
		return arr[index]
	else:
		return alt

class drawUi(object):
	def __init__(self):
		self.ttips = gtk.Tooltips()
		pass

	def addTip(self, obj, tip):
		self.ttips.set_tip(obj,tip)
	
	def addRows(self, obj, table, col1,col2, row1,row2,cnn="",function=None):
		table.attach(obj, col1, col2, row1, row2)
		obj.show()
		if cnn!="": obj.connect(cnn, function)
		return obj

	def addObjs(self, arrobj, table):
		objs=[]
		for data in arrobj:
			if type(data) is list:
				obj=data[0]
				if type(obj) is str or type(obj) is unicode:
					obj=self.addLabel(obj)
				col1=defIndex(data,1)
				col2=defIndex(data,2)
				row1=defIndex(data,3)
				row2=defIndex(data,4)
				cnn =defIndex(data,5,'')
				fn  =defIndex(data,6)
				objs.append(self.addRows(obj, table, col1,col2, row1,row2,cnn,fn))
			if type(data) is int:
				objs.append(data)
		return objs

	def addProps(self,obj,props):
		for Key,Value in props:
			obj.set_property(Key, Value)

	def addLabel(self,tx,alignx=1.0,aligny=0.5):
		lb = gtk.Label(tx)
		lb.set_alignment(alignx,aligny)
		return lb
	
	def fillCombo(self, Store, combobox):
		st = combobox.get_model()
		st.clear()
		for n in Store: st.append(n)
		combobox.set_model(st)
		combobox.set_active(0)
	
	def fillCombo2(self, Store, combobox):
		st = combobox.get_model()
		st.clear()
		for n in Store: st.append([Store[n]['tit'],n])
		combobox.set_model(st)
		combobox.set_active(0)
	
	def makeCombo(self, Store):
		st = gtk.ListStore(str, int)
		self.cmb = gtk.ComboBox(st)
		cell = gtk.CellRendererText()
		self.fillCombo(Store,self.cmb)
		self.cmb.pack_start(cell, True)
		self.cmb.add_attribute(cell, 'text', 0)
		self.cmb.set_active(0)
		return self.cmb

	def makeCombo2(self, Store):
		st = gtk.ListStore(str, str)
		self.cmb = gtk.ComboBox(st)
		cell = gtk.CellRendererText()
		self.fillCombo2(Store,self.cmb)
		self.cmb.pack_start(cell, True)
		self.cmb.add_attribute(cell, 'text', 0)
		self.cmb.set_active(0)
		return self.cmb

	def table(self, rows=1, columns=1, homogeneous=False, row_s=2,col_s=2):
		tab= gtk.Table(rows,columns, homogeneous)
		tab.set_row_spacings(row_s)
		tab.set_col_spacings(col_s)
		tab.show()
		return tab

	def getValues(self,arrFields):
		return (n.get_value() for n in arrFields)
	
	def getModelVal(self, widget):
		iter = widget.get_active_iter()
		model = widget.get_model()
		lP = model.get_value(iter,1)
		return lP


#-----------------------------------------------------
EPSILON = 0.00001
varBez = 0.551915024494

def pnts2bezs(arrpnts):
	return [bezpnt(p) for p in arrpnts]

def hipot(catA,catB):
	return math.sqrt(catA*catA + catB*catB)

def polyRounded(rad,rot,sides,rad2,inscribed=True):
	bezs=[]
	rrot=math.radians(rot)
	pC=pnt2d(0,rad)
	if rad2 == 0.0 :
		for n in range(int(sides)):
			bezs.append(bezpnt([pC.x,pC.y]))
			pC.rotate(rrot)
	else:
		if inscribed:
			bez = arcLinesBez(pC,pnt2d(0,rad).rotate(rrot),pnt2d(0,rad).rotate(-rrot),rad2)
		else:
			rrot=math.radians(360/sides)
			rot=(360/sides)
			r1=rot * 0.5
			bez=createArcBez(rad2, math.radians(r1+90), math.radians(-r1+90))
			bez=[b.translate(0,rad-rad2) for b in bez]
		for rr in range(int(sides)): bezs.extend(rotArcBez(bez,-rot*rr))
	return bezs

def lineaTrazos(P1,p2,l):
	lx = p2[0]-P1[0]
	ly = p2[1]-P1[1]
	len = hipot(lx,ly)
	prop = l / len
	tot=len / (l * 2.0)
	p1x=lx / tot
	p1z=ly / tot
	pnts=[]
	for i in range(int(math.ceil(tot/2.0))):
		pnts.append([bezpnt([P1[0]+p1x*(i*2),P1[1]+p1z*(i*2)]),bezpnt([P1[0]+p1x*(i*2+1),P1[1]+p1z*(i*2+1)])])
	return pnts


def polySideLen(radius,sides):
	return 2.0 * radius * math.sin(math.radians(180.0/sides))

def pntAtDist(p1,p2,dist):
	p3= pnt2d(p2.x - p1.x,p2.y - p1.y)
	length = p3.length()
	p4=pnt2d(p3.x/length,p3.y/length)
	p4.scale(dist,dist)
	return pnt2d(p1.x+p4.x, p1.y+p4.y)

def angBetween2Lines(pC,p1,p2): # pC punto comun
	return math.atan2(pC.y-p1.y, pC.x-p1.x) - math.atan2(pC.y-p2.y, pC.x-p2.x)

def createSmallArcBez(r, a1, a2):
	a = (a2 - a1) * 0.5
	p4 = pnt2d(r * math.cos(a), r * math.sin(a))
	p1 = pnt2d(p4.x, -p4.y)
	k = 0.5522847498
	f = k * math.tan(a)
	p2 = pnt2d(p1.x + f * p4.y, p1.y + f * p4.x)
	p3 = pnt2d(p2.x,-p2.y) 
	ar = a + a1
	P1 = pnt2d(r * math.cos(a1), r * math.sin(a1)) 
	P2 = pnt2d(p2.x, p2.y).rotate(ar)
	P3 = pnt2d(p3.x, p3.y).rotate(ar)
	P4 = pnt2d(r * math.cos(a2),r * math.sin(a2))
	B1=bezpnt(P1,None,P2)
	B2=bezpnt(P4,P3)
	return [B1,B2]

def createArcBez(rad, sAng, eAng, posY=0.0):
	bezs =[]
	pi2 = math.pi * 2
	sAng,eAng = (sAng % pi2, eAng % pi2)
	piOver2 = math.pi * 0.5
	sign = 1 if (sAng < eAng) else -1
	a1 = sAng
	totAng = min(math.pi * 2, abs(eAng - sAng))
	while (totAng > EPSILON):
		a2 = a1 + sign * min(totAng, piOver2)
		bezs.extend(createSmallArcBez(rad, a1, a2))
		totAng = totAng - abs(a2 - a1)
		a1 = a2
	return bezs

def rotArcBez(bezs,ang):
	pts2=[]
	rrr = math.radians(ang)
	for bez in bezs:
		bp=bezpnt().copy(bez).rotate(rrr)
		pts2.extend([bp])
	return pts2

def arcLinesBez(pC,P1,P2,rad):
	tBezs = []
	Rot = angBetween2Lines(pC,P1,P2)
	hipo=rad/math.sin(Rot * 0.5)
	catB=rad/math.tan(Rot * 0.5)
	bz1 = pntAtDist(pC,P1,catB)
	bx1 = pntAtDist(pC,P2,catB)
	pC2 = pnt2d(0,-hipo+pC.y)
	Rot2 = angBetween2Lines(pC2,bx1,bz1)
	iniRot=(math.pi-Rot2) * 0.5
	tBezs = createArcBez(rad, iniRot, Rot2+iniRot)
	for bez in tBezs:
		bez.translate(0.0,pC.y-abs(hipo))
	return tBezs

def starRoundBez(rad,radInt,rot,sides,rad2):
	bezs=[]
	rrot=math.radians(rot)
	pC, pC2=(pnt2d(0,rad), pnt2d(0,radInt))
	if rad2 == 0.0 :
		pC2.rotate(rrot)
		for n in range(int(sides * 0.5)):
			bezs.extend([bezpnt([pC.x,pC.y]),bezpnt([pC2.x,pC2.y])])
			pC.rotate(rrot*2)
			pC2.rotate(rrot*2)
	else:
		pts = arcLinesBez(pC,pnt2d(0,radInt).rotate(rrot),pnt2d(0,radInt).rotate(-rrot),rad2)
		pC2.rotate(-rrot)
		for rr in range(int(sides)):
			if rr % 2 == 0:
				bezs.extend(rotArcBez(pts,-rot*rr))
			else:
				bezs.append(bezpnt(pnt2d(pC2.x,pC2.y)))
				pC2.rotate(-rrot*2)
	return bezs

def bezCross(x,y,size):
	bezs=[]
	bezs.extend([bezpnt([x,y-size]),bezpnt([x,y+size])])
	bezs.extend([bezpnt([x-size,y]),bezpnt([x+size,y])])
	return bezs

def bbox(bezs):
	minx=10000000
	miny=10000000
	maxx=-10000000
	maxy=-10000000
	for b in range(len(bezs)-1):
		p=bezs[b].fixed
		minx=min(minx,p.x)
		miny=min(miny,p.y)
		maxx=max(maxx,p.x)
		maxy=max(maxy,p.y)
		gimp.message(str(minx))
		gimp.message(str(miny))
		gimp.message(str(maxx))
		gimp.message(str(maxy))
		gimp.message(str(p))
#--------------------------------------------------------------
#--------------------------------------------------------------
#--------------------------------------------------------------
#--------------------------------------------------------------	


def debug(val):
	gimp.message(str(val))

gettext.install("arakne-path-shape-creator", p, unicode=True)

varBez = 0.551915024494

pathcreator_key='arakne-shape-creator'

CORNERS=[[_('Rounded'),0],[_('Rounded inverse'),1],[_('Chamfer'),2]]
CORNERSROMB=[[_('Rounded'),0],[_('Chamfer'),1]]
POLYSEL=[[_('Polygon'),0],[_('Circle'),1]]
ArrowSEL=[[_('Top'),0],[_('Bottom'),1],[_('Left'),2],[_('Right'),3]]
ArcSEL=[[_('Open'),0],[_('At center'),1],[_('Linear'),2]]
# selection modes:
oppSel=[[_("Add to current"),0],[_("Substract"),1],[_("Replace current"),2],[_("Intersect"),3]]
oppFill=[[_("Don't fill"),0],[_("With foreground"),1],[_("With background"),2],[_("With pattern"),3]]

oppStro=[["Don't stroke",0],["Stroke path",1],["Stroke over fill",2]]
sIntRadius=_("Interior radius")+' %:'

def getRadioIndex(radios):
	index=0
	n=0
	radios=radios['obj']
	for r in radios:
		if r.get_active():
			index=n
		n+=1
	return index

def getVal(o):
	return o['obj'].get_value()

def shapeRectangle(x1,x2,y1,y2, v1,v6):
	name=_('rect')
	bezs=[bezpnt([x1,y1]), bezpnt([x1,y2]), bezpnt([x2,y2]), bezpnt([x2,y1])]
	an, al=(x2 - x1, y2 - y1)
	rad=v1
	if rad>0:
		corners = v6
		if corners==1:
			name+=_('RoundedInv')
			r2=rad*varBez
			fpts2=[[x1+r2,y1+rad], [x1+rad,y1+r2], [x2-rad,y1+r2], [x2-r2,y1+rad], [x2-r2,y2-rad], [x2-rad,y2-r2], [x1+rad,y2-r2], [x1+r2,y2-rad]]
		elif corners in [0,2]:
			name=name+_('chamfer') if corners==2 else name+_('rounded')
			r2=rad if corners==2 else rad*varBez
			fpts2=[[x1,y1+r2], [x1+r2,y1], [x2-r2,y1], [x2,y1+r2], [x2,y2-r2], [x2-r2,y2], [x1+r2,y2], [x1,y2-r2]]
		bezs=[
			bezpnt([x1,y1+rad],None,fpts2[0]), bezpnt([x1+rad,y1],fpts2[1]),
			bezpnt([x2-rad,y1],None,fpts2[2]), bezpnt([x2,y1+rad],fpts2[3]),
			bezpnt([x2,y2-rad],None,fpts2[4]), bezpnt([x2-rad,y2],fpts2[5]),
			bezpnt([x1+rad,y2],None,fpts2[6]), bezpnt([x1,y2-rad],fpts2[7])
		]
	return [name,bezs,_('Max. roundness')+':',min(al,an)*0.5,True]

def shapeRectangle2(x1,x2,y1,y2, objs):
	rad=getVal(objs[1])
	corners = getRadioIndex(objs[0])
	return shapeRectangle(x1,x2,y1,y2, rad,corners)

if useCollections:
	SHAPES2={
		'rect':{
			'tit':_('Rectangle'),
			'def2':shapeRectangle2,
			'objs':[{'label':_("Corners")+':','t':'radio','vals':CORNERS},{'label':_("Roundness")+':','t':'float','adj':[5.0,0.0,200.0,0.2],'digits':2}
			],'grp':_('Rectangular')
		}
	}

def centerBezs(bezs,x1,y1,an,al):
	for bez in bezs: bez.translate(x1+an * 0.5, y1+al * 0.5)
	return bezs

def debugErr(e):
	exc_type, exc_obj, exc_tb = sys.exc_info()
	fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
	debug(fname+'\n'+str(exc_tb.tb_lineno)+'\n'+str(e))

def setProps(obj,props):
	for n in props: obj.set_property(n,props[n])

def gVal(obj):
	n=obj['obj']
	if type(n) is list:
		return getRadioIndex(obj)
	elif type(n) is gtk.SpinButton:
		v = n.get_value()
		if n.get_digits()==0: v=int(v)
		return v
	elif type(n) is gtk.ComboBox: 
		return n.get_active()
	elif type(n) is gtk.CheckButton: 
		return n.get_active()

def getVals(objs):
	vals=[]
	for a in objs:
		n=a['obj']
		if type(n) is list:
			vals.append(getRadioIndex(a))
		elif type(n) is gtk.SpinButton:
			v = n.get_value()
			if n.get_digits()==0: v=int(v)
			vals.append(v)
		elif type(n) is gtk.ComboBox: 
			vals.append(n.get_active())
		elif type(n) is gtk.CheckButton: 
			vals.append(n.get_active())
	return vals

def chAdj(obj, Min=None, Max=None):
	adj1=obj['obj'].get_adjustment()
	if Min!=None: adj1.set_lower(Min)
	if Max!=None: adj1.set_upper(Max)

def chVal(obj,val):
	obj['obj'].set_value(val)

def enableObj(obj,enabled=True,txLabel=None):
	obj['obj'].set_sensitive(enabled)
	obj['lb'].set_sensitive(enabled)

#SHAPES IMPORT FIX
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#SKIP TO LINE 2005

def bezsEllipse(x1,x2,y1,y2):
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an/2, al/2)
	xBez, yBez=(varBez*an2, varBez*al2)
	bezs=[bezpnt([x1,y1+al2],[x1,y1+al2-yBez],[x1,y1+al2+yBez]),bezpnt([x1+an2,y2],[x1+an2-xBez,y2],
		[x1+an2+xBez,y2]),bezpnt([x2,y1+al2],[x2,y1+al2+yBez],[x2,y1+al2-yBez]),bezpnt([x1+an2,y1],
		[x1+an2+xBez,y1],[x1+an2-xBez,y1])]
	return bezs

def shapeEllipse(x1,x2,y1,y2,objs):
	bezs=bezsEllipse(x1,x2,y1,y2)
	hr=' - '+_('Horizontal')+": "+str((x2-x1)*0.5)+'px\n'
	hv=' - '+_('Vertical')+": "+str((y2-y1)*0.5)+'px'
	return [_("ellipse"),bezs,_('Radius')+':\n'+hr+hv,'',True]

def bezsArc(x1,x2,y1,y2, rot1, rot2, close):
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an/2,al/2)
	la = min(an,al)
	bezs=createArcBez(la/2, math.radians(rot1),math.radians(rot2))
	if close==1:bezs.append(bezpnt([0,0]))
	return centerBezs(bezs,x1,y1,an,al)

def shapeArc(x1,x2,y1,y2, objs):
	v1,v2=(getVal(objs[0]),getVal(objs[1]))
	v6=getRadioIndex(objs[2])
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an/2,al/2)
	la = min(an,al)/2.0
	name=_('arc')+str(int(v1))+'_'+str(int(v2))
	bezs=createArcBez(la, math.radians(v1),math.radians(v2))
	if v6==1:bezs.append(bezpnt([0,0]))
	closed=v6>0
	bezs=centerBezs(bezs,x1,y1,an,al)
	msg=_('Radius')+': '+str(la)+'px'
	return [name,bezs,'',msg,closed]

SHAPES2['ellip']={'tit':_('Ellipse'),'def2':shapeEllipse,'objs':[],'grp':_('Circular')}

SHAPES2['arc']={'tit':_('Arc'),'def2':shapeArc,
	'objs':[
		{'t':'float','adj':[ 0.0,-360.0,360.0,0.2],'digits':2,'label':_("Start angle")+':'},
		{'t':'float','adj':[90.0,-360.0,360.0,0.2],'digits':2,'label':_("End angle")+':'},
		{'label':_("Closed")+':'       ,'t':'radio','vals':ArcSEL}
	],'grp':_('Circular')
}

def angBetween2pnts(P1,P2):
	rot = math.atan2(P2.y - P1.y, P2.x - P1.x)
	if rot<0: rot = rot+2*math.pi
	return rot

def shapeArch2(x1,x2,y1,y2, objs):
	bezs=[]
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an * 0.5, al * 0.5)
	p1=pnt2d(0,0)
	tipo,v1,v2=getVals(objs)
	r180=math.radians(180.0)
	r270=math.radians(270.0)
	r90=math.radians(90.0)
	# lancet|ojival
	if tipo==0:
		chAdj(objs[1],an2)
		if v1<an2: 
			objs[1]['obj'].set_value(an2)
			v1 = an2
		enableObj(objs[2],False) #obj,enabled=True,txLabel=None
		p2=pnt2d(an2,v1)
		ang=angBetween2pnts(p1,p2)
		side=math.sqrt(an2*an2+v1*v1)
		hypo=side/math.cos(ang)
		ang2=angBetween2pnts(pnt2d(an2,v1),pnt2d(hypo * 0.5,0))
		ang2=r180 - ang2
		bezs=createArcBez(math.fabs(hypo * 0.5), r180, ang2)
		arc2=createArcBez(math.fabs(hypo * 0.5), r180 - ang2, math.radians(359.99999))
		for n in bezs: n.translate(x1+hypo * 0.5,y1+v1)
		for n in arc2: n.translate(-hypo * 0.5 + x1 + an,y1+v1)
		bezs.extend(arc2)
		if v1<al: bezs.extend([bezpnt([x2,y2]),bezpnt([x1,y2])])
		return ["archLancet"+str(v1),bezs,_('Minimal height')+':','>'+str(an2),True]
	else:
		r=v1
		if r<an2: r=an2
		r2=v2
		hipo, cat = (r - r2, an2 - r2)
		catB = math.sqrt((hipo*hipo) - (cat*cat))
		rot  = math.asin(cat/hipo)
		bezs=[]
		enableObj(objs[2],True)
		bzs = createArcBez(r2, r180, r270 - rot)
		for n in bzs:
			n.translate(x1+r2, y1+r-catB)
			bezs.append(n)
		bzs = createArcBez(r,-rot - r90,rot - r90)
		for n in bzs:
			n.translate(x1+an2,y1+r)
			bezs.append(n)
		bzs = createArcBez(r2, r270 - rot,r180)
		for n in bzs:
			n.scale(-1,1)
			n.translate(x2-r2,y1+r-catB)
			bezs.append(n)
		bezs.extend([bezpnt([x2,y2]),bezpnt([x1,y2])])

		return ["archBasket"+str(v1),bezs,'Minimal height:','>'+str(an2),True]

SHAPES2['arch']={'tit':_('Arches'),'def2':shapeArch2,
	'objs':[
		{'t':'combo','vals':[[_('Lancet'),0],[_('Basket-handle'),0]],'label':_("Type")+':'},
		{'t':'float','adj':[120,0.0,'h',0.2],'digits':2,'label':_("Radius")+' A (px):'},
		{'t':'float','adj':[120,0.0,'h',0.2],'digits':2,'label':_("Radius")+' B (px):'}
	],'grp':_('Others'),
	'img':[0,['arches0.png','arches1.png']]
}

def shapeArrow2(x1,x2,y1,y2, objs):
	Type,dir,hW,hH,tW,both=getVals(objs)
	active=True if Type==0 else False

	objs[4]['obj'].set_sensitive(active)

	an2,al2=((x2-x1)*0.5,(y2-y1)*0.5)
	if tW==0:tW=1
	cx,cy=(x1+an2,y1+al2)
	if both:
		if Type==0:
			if dir in [0,1]:
				pts=[[cx,y1],[cx+hW,y1+hH],[cx+tW,y1+hH],[cx+tW,y2-hH],[cx+hW,y2-hH],[cx,y2],[cx-hW,y2-hH],
					[cx-tW,y2-hH],[cx-tW,y1+hH],[cx-hW,y1+hH]]
			if dir in [2,3]:
				pts=[[x1,cy],[x1+hH,cy+hW],[x1+hH,cy+tW],[x2-hH,cy+tW],[x2-hH,cy+hW],[x2,cy],[x2-hH,cy-hW],
					[x2-hH,cy-tW],[x1+hH,cy-tW],[x1+hH,cy-hW]]
			bezs=[bezpnt(p) for p in pts]
			return [_("Arrow"),bezs,'',0,True]
		if Type==1:
			if dir in [0,1]:
				pts1=[[cx,y1],[cx,y2]]
				pts2=[[cx-hW,y1+hH],[cx,y1],[cx+hW,y1+hH]]
				pts3=[[cx-hW,y2-hH],[cx,y2],[cx+hW,y2-hH]]
			elif dir in [2,3]:
				pts1=[[x1,cy],[x2,cy]]
				pts2=[[x1+hH,cy-hW],[x1,cy],[x1+hH,cy+hW]]
				pts3=[[x2-hH,cy-hW],[x2,cy],[x2-hH,cy+hW]]
			bezs=[]
			bezs.append([bezpnt(p) for p in pts1])
			bezs.append([bezpnt(p) for p in pts2])
			bezs.append([bezpnt(p) for p in pts3])
			return [_("ArrowStick"),bezs,'',0,False]
		if Type==2:
			if dir in [0,1]:
				pts1=[[cx,y1+hH],[cx,y2-hH]]
				pts2=[[cx-hW,y1+hH],[cx,y1],[cx+hW,y1+hH],[cx-hW,y1+hH]]
				pts3=[[cx-hW,y2-hH],[cx,y2],[cx+hW,y2-hH],[cx-hW,y2-hH]]
			elif dir in [2,3]:
				pts1=[[x1+hH,cy],[x2-hH,cy]]
				pts2=[[x1+hH,cy-hW],[x1,cy],[x1+hH,cy+hW],[x1+hH,cy-hW]]
				pts3=[[x2-hH,cy-hW],[x2,cy],[x2-hH,cy+hW],[x2-hH,cy-hW]]
			bezs=[]
			bezs.append([bezpnt(p) for p in pts1])
			bezs.append([bezpnt(p) for p in pts2])
			bezs.append([bezpnt(p) for p in pts3])
			return [_("ArrowStick"),bezs,'',0,False]
	else:
		if Type==0:
			pts=[[cx,y1],[cx+hW,y1+hH],[cx+tW,y1+hH],[cx+tW,y2],[cx-tW,y2],[cx-tW,y1+hH],[cx-hW,y1+hH]]
			if dir==1:
				pts=[[cx,y2],[cx+hW,y2-hH],[cx+tW,y2-hH],[cx+tW,y1],[cx-tW,y1],[cx-tW,y2-hH],[cx-hW,y2-hH]]
			elif dir==2:
				pts=[[x1,cy],[x1+hH,cy+hW],[x1+hH,cy+tW],[x2,cy+tW],[x2,cy-tW],[x1+hH,cy-tW],[x1+hH,cy-hW]]
			elif dir==3:
				pts=[[x2,cy],[x2-hH,cy+hW],[x2-hH,cy+tW],[x1,cy+tW],[x1,cy-tW],[x2-hH,cy-tW],[x2-hH,cy-hW]]
			bezs=[bezpnt(p) for p in pts]
			return [_("Arrow"),bezs,'',0,True]
		if Type==1:
			pts1=[[cx,y1],[cx,y2]]
			pts2=[[cx-hW,y1+hH],[cx,y1],[cx+hW,y1+hH]]
			if dir==1:
				pts1=[[cx,y1],[cx,y2]]
				pts2=[[cx-hW,y2-hH],[cx,y2],[cx+hW,y2-hH]]
			elif dir==2:
				pts1=[[x1,cy],[x2,cy]]
				pts2=[[x1+hH,cy-hW],[x1,cy],[x1+hH,cy+hW]]
			elif dir==3:
				pts1=[[x1,cy],[x2,cy]]
				pts2=[[x2-hH,cy-hW],[x2,cy],[x2-hH,cy+hW]]
			bezs=[]
			bezs.append([bezpnt(p) for p in pts1])
			bezs.append([bezpnt(p) for p in pts2])
			return [_("ArrowStick"),bezs,'',0,False]
		if Type==2:
			pts1=[[cx,y1+hH],[cx,y2]]
			pts2=[[cx-hW,y1+hH],[cx,y1],[cx+hW,y1+hH],[cx-hW,y1+hH]]
			if dir==1:
				pts1=[[cx,y1],[cx,y2-hH]]
				pts2=[[cx-hW,y2-hH],[cx,y2],[cx+hW,y2-hH],[cx-hW,y2-hH]]
			elif dir==2:
				pts1=[[x1+hH,cy],[x2,cy]]
				pts2=[[x1+hH,cy-hW],[x1,cy],[x1+hH,cy+hW],[x1+hH,cy-hW]]
			elif dir==3:
				pts1=[[x1,cy],[x2-hH,cy]]
				pts2=[[x2-hH,cy-hW],[x2,cy],[x2-hH,cy+hW],[x2-hH,cy-hW]]
			bezs=[]
			bezs.append([bezpnt(p) for p in pts1])
			bezs.append([bezpnt(p) for p in pts2])
			return [_("ArrowStick"),bezs,'',0,False]

SHAPES2['arrow']={
	'tit':_('Arrow'),
	'def2':shapeArrow2,
	'objs':[
		{'label':_("Type")+':'  ,'t':'radio','vals':[[_('Filled'),0],[_('Stick'),1],[_('Stick filled'),2]],'dir':'h'},
		{'label':_("Direction")+':'  ,'t':'combo','vals':[[_('Top'),0],[_('Bottom'),1],[_('Left'),1],[_('Right'),1]]},
		{'label':_("Head width")+':' ,'t':'float','adj':[5.0,2.0,200.0,0.2],'digits':2},
		{'label':_("Head height")+':','t':'float','adj':[9.0,2.0,200.0,0.2],'digits':2},
		{'label':_("Tail width")+':' ,'t':'float','adj':[0.2,2.0,200.0,0.2],'digits':2},
		{'label':""                  ,'t':'check','tx':_("Both ends"),'digits':2}
],'grp':_('Others')}

def shapeBox(x1,x2,y1,y2, objs):
	tipo,H,pest,guides=getVals(objs)

	an,al = (x2-x1,y2-y1)
	if tipo == 0:
		w = (an-pest) * 0.25
		h = (al - H) * 0.5
		if h * 2 > (an - pest):
			h = (an-pest) * 0.25
			w2 = h
		else:
			w2 = (an-pest - h * 2) * 0.5 
			w = h
	else:
		w = (an-pest) * 0.25
		alp=al-pest
		h = (alp - H) * 0.5
		if h * 2 > (an - pest):
			h = (an-pest) * 0.25
			w2 = h
		else:
			w2 = (an-pest - h * 2) * 0.5 
			w = h

	xa = 0
	xb = w2
	xc = w2 + pest
	xd = w2 + w - pest
	xe = w2 + w
	xf = w2 + w + pest
	xg = w2 + w + w2 - pest
	xh = w2 + w + w2
	xi = w2 + w + w2 + pest
	xj = w2 + w + w2 + w - pest
	xk = w2 + w + w2 + w 
	xl = w2 + w + w2 + w + pest

	ya = 0
	yb = h - pest
	yc = h
	yd = h + H
	ye = h + H + pest
	yf = h + H + h

	closed=False if guides else True

	if tipo == 0:
		if guides:
			bezs=lineaTrazos([xa+x1,yc+y1],[xk+x1,yc+y1],2)
			for p in [[[xb,yc],[xb,yd]],[[xe,yc],[xe,yd]],[[xh,yc],[xh,yd]],[[xk,yc],[xk,yd]],[[xa,yd],[xk,yd]]]:
				bezs.extend(lineaTrazos([p[0][0]+x1,p[0][1]+y1],[p[1][0]+x1,p[1][1]+y1],2))
		else:
			pts=[[xa,ya],[xb,ya],[xb,yc],[xc,yb],[xd,yb],[xe,yc],[xf,yb],[xg,yb],[xh,yc],[xi,yb],[xj,yb],[xk,yc],[xl,yc+pest],
				[xl,yd-pest],[xk,yd],[xj,ye],[xi,ye],[xh,yd],[xg,ye],[xf,ye],[xe,yd],[xd,ye],[xc,ye],[xb,yd],[xb,yf],[ya,yf]]
			bezs=[[bezpnt([p[0]+x1,p[1]+y1]) for p in pts]]
	else:
		if guides:
			bezs=lineaTrazos([xa+x1,yc+y1+pest],[xk+x1,yc+y1+pest],2)
			for p in [[[xb,yc],[xb,yd]],[[xe,yc],[xe,yd]],[[xh,yc],[xh,yd]],[[xk,yc],[xk,yd]],[[xa,yd],[xk,yd]],[[xa,ya],[xb,ya]]]:
				bezs.extend(lineaTrazos([p[0][0]+x1,p[0][1]+y1+pest],[p[1][0]+x1,p[1][1]+y1+pest],2))
		else:
			pts=[[xa,ya],
				[xa+pest,ya-pest],[xb-pest,ya-pest],
				[xb,ya],[xb,yc],[xc,yb],[xd,yb],[xe,yc],#[xf,yb],[xg,yb],
				[xh,yc],[xi,yb],[xj,yb],[xk,yc],[xl,yc+pest],
				[xl,yd-pest],[xk,yd],[xj,ye],[xi,ye],[xh,yd],[xg,ye],[xf,ye],[xe,yd],[xd,ye],[xc,ye],[xb,yd],[xb,yf],[ya,yf]]
			bezs=[[bezpnt([p[0]+x1,p[1]+y1+pest]) for p in pts]]
	return [_("Box"),bezs,_('Dimensions:')+"\n",_("Width:")+str(w2)+'\n'+_("Length:")+str(w)+'\n'+_("Height:")+str(H),closed]

SHAPES2['Box']={'tit':_('Box'),
	'def2':shapeBox,
	'objs':[
		{'t':'combo','vals':[[_('Fixed'),0],[_('Movil'),1]],'label':_("Type")+':'},
		{'t':'float','adj':[10,11.0,500.0,0.2],'digits':2,'label':_("Height")+' A (px):'},
		{'t':'float','adj':[10,11.0,500.0,0.2],'digits':2,'label':_("Flap size")+' B (px):'},
		{'t':'check','label':""               ,'tx':_("Create folding lines")}
	],'grp':_('Foldables'),
	'img':[0,['box1.png','box2.png']]
}

def tile1(x1,x2,y1,y2,r,sep,lx,ly,corners):
	eX,eY=(min(x2,lx),min(y2,ly))
	name,bzs,n,nn,nnn=shapeRectangle(x1+sep, eX-sep, y1+sep, eY-sep, r,corners)
	return bzs

def shapeTiles2(x1,x2,y1,y2, objs):
	an,al=(x2-x1,y2-y1)
	bezs=[]
	px,py=(x1,y1)
	Type,vW,v2,sep,Corners,Round=getVals(objs)
	if vW==0: vW=1
	if v2==0: v2=1
	msg=""
	msgTit=""
	if (an/vW)>50:
		vW=an/50.0
		msgTit="ERROR:"
		msg+=_('Too many x rectangles\nSpace X changed to')+':'+str(vW)+'\n'
	if (al/v2)>50:
		v2=al/50.0
		msgTit="ERROR:"
		msg+=_('Too many y rectangles\nSpace Y changed to')+':'+str(v2)
	xx=1
	yy=1
	vS=sep/2.0 if sep>0 else 0
	if Type==3:
		while py<y2:
			yy=0 if yy==1 else 1
			px=x1
			while px<x2:
				width = vW if (px==x1 and yy==0) else vW*2
				bezs.append(tile1(px,px+width,py,py+v2, Round, vS,x2,y2,Corners))
				px += width
			py+=v2
	elif Type==4:
		i=0.0
		while py<y2:
			yy=0 if yy==1 else 1
			px=x1+(vW*i)
			while px<x2:
				if i==2.0 and px==x1+(vW*i): bezs.append(tile1(x1, x1+vW,py,py+vW, Round, vS,x2,y2,Corners))
				if i==3.0 and px==x1+(vW*i): bezs.append(tile1(x1, x1+vW*2,py,py+vW, Round,vS,x2,y2,Corners))
				# uno de 1*2
				al=py+vW*2 if py+vW<y2 else py+vW
				bezs.append(tile1(px,px+vW,py,al, Round, vS,x2,y2,Corners))
				px += vW
				if px<x2:
					an=px+vW*2 if px+vW<x2 else px+vW
					bezs.append(tile1(px,an,py,py+vW, Round,vS,x2,y2,Corners))
				if py==y1 and px+vW*2<x2: bezs.append(tile1(px+vW*2,px+vW*3,py,py+vW, Round,vS,x2,y2,Corners))
				px += (vW*3)
			py += vW
			i += 1.0
			if i > 3.0: i = 0
	else:
		while px<x2:
			py = y1
			xx=0 if xx==1 else 1
			yy=xx
			while py<y2:
				if Type==2:
					yy=1
				elif Type in [0,1]:
					yy=0 if yy==1 else 1
				if (Type==0 and yy==1) or (Type==1 and yy==0) or (Type==2):
					bezs.append(tile1(px,px+vW,py,py+v2, Round, vS, x2,y2,Corners))
				py+=v2
			px+=vW
	
	return [_("Checker"),bezs,msgTit,msg,True]

oppTiles=[["Checker A",0],["Checker B",1],["Tiles",2],["Bricks",3],["Tiles B",4]]

SHAPES2['tiles']={'tit':_('Tiles'),'def2':shapeTiles2,'objs':[
		{'label':_("Type")+':'     ,'t':'combo','vals':oppTiles},
		{'label':_("Width")+':'    ,'t':'float','adj':[20.0,2.0,200.0,0.2],'digits':2},
		{'label':_("Height")+':'   ,'t':'float','adj':[10.0,2.0,200.0,0.2],'digits':2},
		{'label':_("Distance")+':' ,'t':'float','adj':[0.0,0.0,200.0,0.2],'digits':2},
		{'label':_("Corners")+':'  ,'t':'combo','vals':CORNERS},
		{'label':_("Roundness")+':','t':'float','adj':[0.0,0.0,200.0,0.2],'digits':2}
	],'grp':_('Grids')
	
}

def computeDpt(r1, r2, theta):
	return math.sqrt(math.pow(r1 * math.sin(theta), 2) + math.pow(r2 * math.cos(theta), 2))

def elliVerts(r1,r2,n):
	deltaTheta = 0.001
	numIntegrals = math.floor(math.pi * 2.0 / deltaTheta)
	circ, dpt, theta, i=(0.0, 0.0, 0.0, 0)
	while (i<numIntegrals):
		theta += i*deltaTheta
		dpt = computeDpt( r1, r2, theta)
		circ += dpt
		i += 1
	nextPoint,run,theta, i = (0, 0.0, 0.0,0)
	pnts=[]
	while(i < numIntegrals):
		theta += deltaTheta
		subIntegral = n * run / circ
		if (int(subIntegral) >= nextPoint):
			pnts.append([r1 * math.cos(theta),r2 * math.sin(theta)])
			nextPoint += 1
		run += computeDpt(r1, r2, theta)
		i += 1
	return pnts

def angBetween2pts(P1,P2):
	rot = math.degrees(math.atan2(P2[0] - P1[0], P2[1] - P1[1]))
	if rot<0: rot = rot + 360.0
	return rot

def lineLen(P1,P2):
	return math.sqrt(math.pow(P2[0] - P1[0],2)+math.pow(P2[1] - P1[1],2))

def halfCirc(x1,x2,y1,y2):
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an*0.5, al*0.5)
	xBez, yBez=(varBez*an2, varBez*al2)

	bezs=[bezpnt([x2,y1+al2],None,[x2,y1+al2+yBez]),
		bezpnt([x1+an2,y2],[x1+an2+xBez,y2],[x1+an2-xBez,y2]),
		bezpnt([x1,y1+al2],[x1,y1+al2+yBez])]
	return bezs

def shapeCloud(x1,x2,y1,y2, objs):
	an=(x2-x1) * 0.5
	al=(y2-y1) * 0.5
	v3=int(getVal(objs[0]))
	bezs=[]
	msgTit=""
	msg=""
	pts=elliVerts(an,al,v3)
	old=None
	for n in range(v3):
		a = pts[n]
		b = pts[n+1] if n<len(pts)-1 else pts[0]
		radio = lineLen(a,b) * 0.5
		rot = angBetween2pts(a,b)
		bz=halfCirc(0,radio * 2.0,-radio,radio)
		Angle = math.degrees(math.atan2(a[1]-b[1], a[0]-b[0]))
		if (Angle < 0): Angle += 360.0
		for nn in bz: nn.rotate(math.radians(Angle)).translate(b[0] + x1 + an,b[1] + y1 + al)
		if old: bz[0].fixed = old
		old=bz[2].fixed
		bezs.extend(bz)
	bezs[0].fixed = old
	return [_("Cloud")+str(v3),bezs,msgTit,msg,True]

SHAPES2['think']={
	'tit' :_('Cloud'),
	'def2':shapeCloud,
	'objs':[{'label':_("Parts")+':' ,'t':'float','adj':[5,3,200,1],'digits':0}],'grp':_('Circular')
}

def shapeCross2(x1,x2,y1,y2, objs):
	name=_('cross')
	crW,corners,rad=getVals(objs)
	an, al=(x2 - x1, y2 - y1)
	an2,al2=(an/2,al/2)
	try:
		crw2 = crW/2
		pX = [x1+an2-crw2, x1+an2+crw2]
		pY = [y1+al2-crw2, y1+al2+crw2]
		pts=[[pX[0],y1], [pX[1],y1], [pX[1],pY[0]], [x2, pY[0]], [x2, pY[1]], [pX[1],pY[1]],
			[pX[1],y2], [pX[0],y2], [pX[0],pY[1]], [x1,pY[1]], [x1,pY[0]], [pX[0],pY[0]]]
		bezs=[bezpnt(p) for p in pts]
		# chamfer
		if rad>0:
			r2=rad*varBez
			if corners==2:
				name+=_('Chamfer')
				pts=[[pX[0]+rad,y1], [pX[1]-rad, y1], [pX[1], y1+rad], [pX[1], pY[0]], [x2-rad,pY[0]],
					[x2,pY[0]+rad],  [x2,pY[1]-rad],  [x2-rad,pY[1]],  [pX[1], pY[1]], [pX[1], y2-rad],
					[pX[1]-rad, y2], [pX[0]+rad, y2], [pX[0], y2-rad], [pX[0], pY[1]], [x1+rad,pY[1]],
					[x1,pY[1]-rad],  [x1,pY[0]+rad],  [x1+rad,pY[0]],  [pX[0], pY[0]], [pX[0], y1+rad]]
				bezs=[bezpnt(p) for p in pts]
			elif corners==0:
				name=name+_('Rounded')
				bezs=[
					bezpnt([pX[0]+rad,y1],[pX[0]+r2,y1]),         bezpnt([pX[1]-rad,y1],None,[pX[1]-r2, y1]),
					bezpnt([pX[1],y1+rad],[pX[1],y1+rad-r2]),     bezpnt([pX[1],pY[0]]),
					bezpnt([x2-rad,pY[0]],None,[x2-rad+r2,pY[0]]),bezpnt([x2,pY[0]+rad],[x2,pY[0]+rad-r2]),
					bezpnt([x2,pY[1]-rad],None,[x2,pY[1]-rad+r2]),bezpnt([x2-rad,pY[1]],[x2-rad+r2,pY[1]]),
					bezpnt([pX[1],pY[1]]),                        bezpnt([pX[1],y2-rad],None,[pX[1], y2-rad+r2]),
					bezpnt([pX[1]-rad,y2],[pX[1]-rad+r2, y2]),    bezpnt([pX[0]+rad, y2],None,[pX[0]+rad-r2, y2]),
					bezpnt([pX[0],y2-rad],[pX[0],y2-rad+r2]),     bezpnt([pX[0],pY[1]]),  
					bezpnt([x1+rad,pY[1]],None,[x1+rad-r2,pY[1]]),bezpnt([x1,pY[1]-rad],[x1,pY[1]-rad+r2]),
					bezpnt([x1,pY[0]+rad],None,[x1,pY[0]+rad-r2]),bezpnt([x1+rad,pY[0]],[x1+rad-r2,pY[0]]),
					bezpnt([pX[0], pY[0]]),                       bezpnt([pX[0], y1+rad],None,[pX[0], y1+rad-r2])]
			elif corners==1:
				name=name+_('RoundedInv')
				bezs=[
					bezpnt([pX[0]+rad,y1],[pX[0]+rad,y1+r2]),      bezpnt([pX[1]-rad,y1],None,[pX[1]-rad,y1+r2]),
					bezpnt([pX[1],y1+rad],[pX[1]-r2, y1+rad]),     bezpnt([pX[1],pY[0]]),
					bezpnt([x2-rad,pY[0]],None,[x2-rad,pY[0]+r2]), bezpnt([x2,pY[0]+rad],[x2-r2,pY[0]+rad]),
					bezpnt([x2,pY[1]-rad],None,[x2-r2,pY[1]-rad]), bezpnt([x2-rad,pY[1]],[x2-rad,pY[1]-r2]),
					bezpnt([pX[1],pY[1]]),                         bezpnt([pX[1],y2-rad],None,[pX[1]-r2,y2-rad]),
					bezpnt([pX[1]-rad, y2],[pX[1]-rad, y2-r2]),    bezpnt([pX[0]+rad,y2],None,[pX[0]+rad,y2-r2]),
					bezpnt([pX[0], y2-rad],[pX[0]+r2, y2-rad]),    bezpnt([pX[0], pY[1]]),
					bezpnt([x1+rad,pY[1]],None,[x1+rad,pY[1]-r2]), bezpnt([x1,pY[1]-rad],[x1+r2,pY[1]-rad]),
					bezpnt([x1,pY[0]+rad],None,[x1+r2,pY[0]+rad]), bezpnt([x1+rad,pY[0]],[x1+rad,pY[0]+r2]),
					bezpnt([pX[0], pY[0]]),                        bezpnt([pX[0], y1+rad],None,[pX[0]+r2, y1+rad])
				]
		return [name,bezs,_('Max. roundness')+':',crw2,True]
	except Exception,e:
		debugErr(e)

SHAPES2['cross']={'tit':_('Cross'),
	'def2':shapeCross2,
	'objs':[
		{'t':'float','adj':[20.0,0.0,'h',0.2],'digits':2,'label':_("Trav. width")+':'},
		{'t':'combo','vals':CORNERS,'label':_("Corners")+':'},
		{'t':'float','adj':[0.0,0.0,'h',0.2],'digits':2,'label':_("Roundness")+':'}
	],'grp':_('Others')
}

def shapeCrossedCorners(x1,x2,y1,y2, objs):
	p1=[]
	dir,Px,external=getVals(objs)
	w2 = Px * 0.5
	vb=w2*varBez
	if external:
		x1-=Px
		x2+=Px
		y1-=Px
		y2+=Px
	try:
		if dir==0:
			p1=[bezpnt([x1+Px,y1+w2],None,[x1+Px,y1+w2-vb]), bezpnt([x1+w2,y1],[x1+w2+vb,y1],[x1+w2-vb,y1]),
				bezpnt([x1,y1+w2],[x1,y1+w2-vb],[x1,y1+w2+vb]), bezpnt([x1+w2,y1+Px],[x1+w2-vb,y1+Px],None),
				bezpnt([x2-w2,y1+Px],None,[x2-w2+vb,y1+Px]), bezpnt([x2,y1+w2],[x2,y1+w2+vb],[x2,y1+w2-vb]),
				bezpnt([x2-w2,y1],[x2-w2+vb,y1],[x2-w2-vb,y1]), bezpnt([x2-Px,y1+w2],[x2-Px,y1+w2-vb],None),
				bezpnt([x2-Px,y2-w2],None,[x2-Px,y2-w2+vb]), bezpnt([x2-w2,y2],[x2-w2-vb,y2],[x2-w2+vb,y2]),
				bezpnt([x2,y2-w2],[x2,y2-w2+vb],[x2,y2-w2-vb]), bezpnt([x2-w2,y2-Px],[x2-w2+vb,y2-Px],None),
				bezpnt([x1+w2,y2-Px],None,[x1+w2-vb,y2-Px]), bezpnt([x1,y2-w2],[x1,y2-w2-vb],[x1,y2-w2+vb]),
				bezpnt([x1+w2,y2],[x1+w2-vb,y2],[x1+w2+vb,y2]), bezpnt([x1+Px,y2-w2],[x1+Px,y2-w2+vb],None)
			]
		if dir==1: p1=[bezpnt(n) for n in [[x1+Px,y1],[x1+Px,y2],[x1,y2-Px],[x2,y2-Px],[x2-Px,y2],[x2-Px,y1],[x2,y1+Px],[x1,y1+Px]]]
		if dir==2:
			p=[[x1,y1],[x1+Px,y1],[x1+Px,y2],[x1,y2],[x1,y2-Px],[x2,y2-Px],[x2,y2],[x2-Px,y2],[x2-Px,y1],[x2,y1],[x2,y1+Px],[x1,y1+Px]]
			p1=[bezpnt(n) for n in p]
	except Exception,e:
		debug(e)
	bezs = p1
	return [_("crossedCorners"),bezs,'',0,True]

SHAPES2['crossedcorners']={'tit':_('Crossed corners'),
	'def2':shapeCrossedCorners,
	'objs':[
		{'t':'radio','vals':[[_('Circular'),0],[_('Triangular'),1],[_('Squared'),2]],'label':_("Type")+':'},
		{'t':'float','adj':[10,11.0,500.0,0.2],'digits':2,'label':_("Size")+' (px):'},
		{'label':""                  ,'t':'check','tx':_("External"),'digits':2}
	],'grp':_('Rectangular')
}


def createArcBez2(rad, sAng, eAng, posY=0.0):
	bezs =[]
	pi2 = math.pi * 2
	piOver2 = math.pi / 2.0
	sign = 1 if (sAng < eAng) else -1
	a1 = sAng
	totAng = min(math.pi*2, abs(eAng - sAng))
	while (totAng > EPSILON):
		a2 = a1 + sign * min(totAng, piOver2)
		bezs.extend(createSmallArcBez(rad, a1, a2))
		totAng = totAng - abs(a2 - a1)
		a1 = a2
	return bezs

def shapeDrop(x1,x2,y1,y2, objs):
	an2=(x2-x1) * 0.5
	al2=(y2-y1) * 0.5
	v1,v2=getVals(objs)
	
	maxR=an2 if an2<al2 else al2
	ch=''
	if v1>maxR:
		v1 = maxR
		chVal(objs[0],v1)
		ch=_('Radius top is too big, changed to ') + str(maxR)
	if v2>maxR:
		v2 = maxR
		if ch!='': ch += '\n'
		chVal(objs[1],v2)
		ch += _('Radius bottom is too big, changed to ') + str(maxR)
	catB=v2-v1
	catA=(y2-y1)-(v1+v2)
	rot=math.degrees(math.asin(catB/catA))
	b=createArcBez2(v1, math.radians(-rot),math.radians(-180+rot))
	for n in b:	n.translate(x1+an2,y1+v1)
	B=createArcBez2(v2, math.radians(180+rot),math.radians(-rot))
	for n in B:	n.translate(x1+an2,y2-v2)
	bezs=[]
	bezs.extend(b)
	bezs.extend(B)
	return [_("Drop"),bezs,ch,'',True]

SHAPES2['drop']={'tit':_('Drop'),
	'def2':shapeDrop,
	'objs':[
		{'t':'tit','label':_("Circles radius")+':'},
		{'t':'float','adj':[50.0,0.0,500.0,0.2],'digits':2,'label':_("Top")+' (px):'},
		{'t':'float','adj':[90.0,0.0,500.0,0.2],'digits':2,'label':_("Bottom")+' (px):'}
	]	,'grp':_('Others'),
	'img':'drop.png'
}


def shapeFlower(x1,x2,y1,y2, objs):
	#petals=int(objs[0]['obj'].get_value())
	#v5=objs[1]['obj'].get_value()
	petals,v5=getVals(objs)
	name=_('flower')+str(int(petals))
	an, al=(x2 - x1, y2 - y1)
	la = min(al,an)
	if petals==0.0: petals=1.0
	rot=360.0/petals
	rd=la/2
	if v5==0.0: v5=1.0
	starr2=rd/(100/v5)
	bezs=[]
	lado=2*starr2*math.sin(math.radians(180.0/petals))
	l2=lado*0.5
	pnt=pnt2d(0,starr2).rotdeg(rot/2)
	vB = varBez
	bzs=[bezpnt([-l2,pnt.y],None,[-l2,vB*(rd-starr2)]), bezpnt([0,rd],[-vB*lado*2,rd],[vB*lado*2,rd]), bezpnt([l2,pnt.y],[l2,vB*(rd-starr2)])]
	for rr in range(int(petals)): bezs.extend(rotArcBez(bzs,-rot*rr))
	bezs=centerBezs(bezs,x1,y1,an,al)
	return [name,bezs,'',0,True]

SHAPES2['flower']={'tit':_('Flower'),
	'def2':shapeFlower,
	'objs':[
		{'t':'float','adj':[4,2,30,1],'digits':0,'label':_("Petals")+':'},
		{'t':'float','adj':[25.0,0.0,100.0,0.2],'digits':2,'label':_("Interior radius")+' %:'}
	],'grp':_('Others')
}


def shapeFrame2(x1,x2,y1,y2,objs):

	def halfCirc(x,w,y,h):
		svb = h * varBez 
		w2 = w * 0.5
		w2vb = w2 * varBez
		return [
			bezpnt([x,y]     ,None           ,[x,y+svb]),
			bezpnt([x+w2,y+h],[x+w2-w2vb,y+h],[x+w2+w2vb,y+h]),
			bezpnt([x+w,y]   ,[x+w,y+svb]    ,None)
		]

	an,al=(x2-x1,y2-y1)
	bezs=[]
	p1=[]
	p2=[]
	p3=[]
	Type,w,H,dist,v5=getVals(objs)
	v5 -= 1
	w2=w * 0.5
	Inc=(w+dist)
	totX,totY=(int((an+dist)//Inc),int((al+dist)//Inc))

	if dist<0.0:
		if (totX*Inc+w>=an): totX -= 1
		if (totY*Inc+w>=al): totY -= 1
	inix=(an-(totX*Inc-dist)) * 0.5
	iniy=(al-(totY*Inc-dist)) * 0.5
	suma=v5*H

	if Type==0:
		if inix>0: p1.append(bezpnt([x1,y1]))
		w2vb = w2*varBez
		ip2 = x1+an-inix
		for i in range(0,totX):
			if v5==0: suma = H if (suma==-H or suma==0) else -H
			iInc = i * Inc + inix + x1
			p1.extend(halfCirc(iInc,w,y1,suma))
			Ii=ip2 - Inc*i
			p2.extend(halfCirc(Ii,-w,y2,-suma))
		if dist==0.0: p1.append(bezpnt([totX*Inc+inix+x1,y1]))
		if iniy>0: p1.append(bezpnt([x2,y1]))
		ip3 = y1+al-iniy
		for i in range(0,totY):
			if v5==0: suma = H if (suma==-H or suma==0) else -H
			svb=suma*varBez
			iInc=i*Inc+iniy+y1
			p1.extend([bezpnt([x2,iInc],None,[x2-svb,iInc]),bezpnt([x2-suma,iInc+w2],[x2-suma,iInc+w2-w2vb],[x2-suma,iInc+w2+w2vb]),bezpnt([x2,iInc+w],[x2-svb,iInc+w],None)])
			Ii= ip3 - Inc * i
			p3.extend([bezpnt([x1,Ii],None,[x1+svb,Ii]), bezpnt([x1+suma,Ii - w2],[x1+suma,Ii -w2 + w2vb],None), bezpnt([x1+suma,Ii - w2],None, [x1+suma, Ii-w2 - w2vb]), bezpnt([x1,Ii-w],[x1+svb,Ii-w],None)])
		p1.append(bezpnt([x2,y2]))
		p2.append(bezpnt([x1,y2]))
	if Type==1:
		if inix>0:
			p1.append(bezpnt([x1,y1]))
			p2.append(bezpnt([x1,y2]))
		for i in range(0,totX):
			if v5==0: suma = H if (suma==-H or suma==0) else -H
			iInc=i*Inc+inix+x1
			p1.extend([bezpnt([iInc,y1]),bezpnt([iInc+w2,y1+suma])])
			if dist!=0.0: p1.append(bezpnt([iInc+w,y1]))
			p2.extend([bezpnt([iInc,y2]),bezpnt([i*Inc+w2+inix+x1,y2-suma])])
			if dist!=0.0: p2.append(bezpnt([iInc+w,y2]))
		if dist==0.0: p1.append(bezpnt([totX*Inc+inix+x1,y1]))
		if inix>0: p2.append(bezpnt([x2,y2]))
		if iniy>0: p1.append(bezpnt([x2,y1]))
		for i in range(0,totY):
			if v5==0: suma = H if (suma==-H or suma==0) else -H
			iInc=i*Inc+iniy+y1
			p1.extend([bezpnt([x2, iInc]),bezpnt([x2-suma, iInc+w2])])
			if dist!=0.0: p1.append(bezpnt([x2, iInc+w]))
			p3.extend([bezpnt([x1, iInc]),bezpnt([x1+suma, iInc+w2])])
			if dist!=0.0: p3.append(bezpnt([x1, iInc+w]))
		p2=reversed(p2)
		p3=reversed(p3)
	if Type==2:
		if inix>0:
			p1.append(bezpnt([x1,y1]))
			p2.append(bezpnt([x1,y2]))
		for i in range(0,totX):
			if v5==0: suma = H if (suma==-H or suma==0) else -H
			iInc=i*Inc+inix+x1
			p1.extend([bezpnt([iInc,y1]),bezpnt([iInc,y1+suma]),bezpnt([iInc+w,y1+suma]),bezpnt([iInc+w,y1])])
			p2.extend([bezpnt([iInc,y2]),bezpnt([iInc,y2-suma]),bezpnt([iInc+w,y2-suma]),bezpnt([iInc+w,y2])])
		if dist==0.0: p1.append(bezpnt([totX*Inc+inix+x1,y1]))
		if inix>0: p2.append(bezpnt([x2,y2]))
		if iniy>0: p1.append(bezpnt([x2,y1]))
		for i in range(0,totY):
			if v5==0: suma = H if (suma==-H or suma==0) else -H
			iInc=i*Inc+iniy+y1
			p1.extend([bezpnt([x2, iInc]),bezpnt([x2-suma, iInc]),bezpnt([x2-suma, iInc+w]),bezpnt([x2, iInc+w])])
			p3.extend([bezpnt([x1, iInc]),bezpnt([x1+suma, iInc]),bezpnt([x1+suma, iInc+w]),bezpnt([x1, iInc+w])])
		p2=reversed(p2)
		p3=reversed(p3)
	if Type==3:

		for i in range(0,totX):
			if v5==0: suma = H if (suma==-H or suma==0) else -H
			iInc=i*Inc+inix+x1
			p1.append([bezpnt([iInc,y1+suma]),bezpnt([iInc+w,y1+suma])])
			p2.append([bezpnt([iInc,y2-suma]),bezpnt([iInc+w,y2-suma])])
		if dist==0.0: p1.append(bezpnt([totX*Inc+inix+x1,y1]))

		for i in range(0,totY):
			if v5==0: suma = H if (suma==-H or suma==0) else -H
			iInc=i*Inc+iniy+y1
			p1.append([  bezpnt([x2-suma, iInc]),bezpnt([x2-suma, iInc+w])])
			p3.append([  bezpnt([x1+suma, iInc]),bezpnt([x1+suma, iInc+w])])
		p2=reversed(p2)
		p3=reversed(p3)
	
	bezs=p1
	bezs.extend(p2)
	bezs.extend(p3)
	return [_("Frame"),bezs,'',0,False if type==3 else True]

SHAPES2['frame']={'tit':_('Frame'),
	'def2':shapeFrame2,
	'objs':[
		{'t':'combo','vals':[[_('Circular'),0],[_('Triangular'),1],[_('Square'),2],[_('Dashed'),2]],'label':_("Type")+':'},
		{'t':'float','adj':[5.0,1.0,500.0,0.2],'digits':2,'label':_("Width")+':'},
		{'t':'float','adj':[5.0,0.0,500.0,0.2],'digits':2,'label':_("Height")+':'},
		{'t':'float','adj':[0.0,-100.0,100.0,0.2],'digits':2,'label':_("Distance")+':'},
		{'t':'combo','vals':[[_('Outside'),-1],[_('Alternate'),0],[_('Inside'),1]],'label':_("Direction")+':'}
	],'grp':_('Rectangular')
}


def shapeGear(x1,x2,y1,y2, objs):
	v1,v3,v5=(getVal(objs[0]),getVal(objs[1]),getVal(objs[2]))
	name=_('gear')+str(int(v3))
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an * 0.5,al * 0.5)
	rd = min(an2,al2)
	rot=360/(v3*2)
	rd2=rd-v5
	bezs=[]
	tRad=0
	if v1>0 : tRad=rot/100*v1
	bez=createArcBez(rd, math.radians(0+tRad), math.radians(rot-tRad))
	bez2=createArcBez(rd2, math.radians(rot+tRad), math.radians(rot*2-tRad))
	bez.extend(bez2)
	for rr in range(int(v3)): bezs.extend(rotArcBez(bez,rot*2*rr))
	bezs=centerBezs(bezs,x1,y1,an,al)
	return [name,bezs,_("Radius")+"\n - "+_("Exterior")+":"+str(rd)+"\n - "+_("Interior")+":"+str(rd2),'',True]

SHAPES2['gear']={'tit':_('Gear'),
	'def2':shapeGear,
	'objs':[
		{'t':'float','adj':[15.0,-90.0,90.0,0.2],'digits':2,'label':_("Teeth angle")+':'},
		{'t':'float','adj':[5,2,50,1],'digits':0,'label':_("Teeths")+':'},
		{'t':'float','adj':[20.0,1.0,200.0,0.2],'digits':2,'label':_("Teeth height")+':'}
	],'grp':_('Circular')
}


def shapeGrid(x1,x2,y1,y2,objs):
	msg=""
	msgTit=""
	bezs=[]
	px=x1
	py=y1
	v1,v2=getVals(objs)
	try:
		an=(x2-x1)
		al=(y2-y1)
		if v1==0: v1=1
		if v2==0: v2=1
		if (an/v1)>100:
			msgTit="ERROR:"
			msg+=_('Too many x lines in grid\nSpace X changed to')+':'+str(an/100)+'\n'
			v1=an/100.0
		if (al/v2)>100:
			msgTit="ERROR:"
			msg+=_('Too many y lines in grid\nSpace Y changed to')+':'+str(al/100)
			v2=al/100.0
		while px<x2:
			px+=v1
			bezs.append([bezpnt([px,y1]),bezpnt([px,y2])])
		while py<y2:
			py+=v2
			bezs.append([bezpnt([x1,py]),bezpnt([x2,py])])
	except Exception,e:
		debugErr(e)
	return [_("Grid"),bezs,msgTit,msg,False]

SHAPES2['grid']={
	'tit':_('Grid'),
	'def2':shapeGrid,
	'objs':[
		{'t':'float','adj':[40,0.0,1000,0.2],'digits':2,'label':_("Space X")+' (px):'},
		{'t':'float','adj':[40,0.0,1000,0.2],'digits':2,'label':_("Space Y")+' (px):'}
	],'grp':_('Grids')
}


def shapeHeart(x1,x2,y1,y2, objs):
	name=_('heart')
	an, al=(x2 - x1, y2 - y1)
	msg=''
	if an>al*2:
		I=(an-al*1.5)*0.5
		x1=x1+I
		x2=x2-I
		an=al*1.5
		msg=_('Too wide, changed width')
	an2, al2=(an * 0.5,al * 0.5)
	rad=objs[0]['obj'].get_value()
	Rad=an2 * 0.5
	rBez=varBez*Rad
	rrr=math.atan((Rad)/(al-Rad))*2
	bb = createArcBez(Rad, rrr, math.radians(0))
	r1 = math.radians(90.0)-rrr
	r2 = math.radians(360.0)-math.acos(Rad/(Rad+rad))
	bbA = createArcBez(Rad, r1+math.radians(90.0),math.radians(270.0))
	if rad==0.0:
		lasP=bbA[len(bbA)-1]
		P=bezpnt(lasP.fixed,lasP.prev,[rBez,-Rad])
		bbA[len(bbA)-1]=P
		bbA.extend([bezpnt([Rad,0],[Rad,-rBez],[Rad,-rBez])])
		bbC = createArcBez(Rad, math.radians(270.0), r1+math.radians(90.0))
		for b in bbC: b.scale(-1,1).translate(Rad*2.0,0)
		lasP=bbC[0]
		P=bezpnt(lasP.fixed,[Rad*2-rBez,-Rad],lasP.next)
		bbC[0]=P
		bbA.extend(bbC)
	else:
		bbB = createArcBez(Rad, math.radians(270.0),r2)
		bbA.extend(bbB)
		catb=math.sqrt(math.pow(Rad+rad,2)-math.pow(Rad,2))
		r3=math.radians(90)-r2
		bbC = createArcBez(rad, -r3,r3)
		for b in bbC: b.rotate(math.radians(270)).translate(Rad,-catb)
		bbA.extend(bbC)
		bbD = createArcBez(Rad,r2,  r1+math.radians(90))
		for b in bbD : b.scale(-1,1).translate(Rad*2,0)
		bbA.extend(bbD)
	bbA.append(bezpnt([Rad,al-Rad]))
	for b in bbA: b.translate(Rad+x1,Rad+y1)
	bezs=bbA
	return [name,bezs,msg,'',True]

SHAPES2['heart']={'tit':_('Heart'),'def2':shapeHeart,
	'objs':[{'t':'float','adj':[10.0,0.0,300,0.2],'digits':2,'label':_("Roundness")+':'}],
	'grp':_('Others')
}


def shapeLetter(x1,x2,y1,y2, objs):
	h,guides=getVals(objs)
	an,al=(x2-x1,y2-y1)
	an2,al2=(an/2.0,al/2.0)
	if h==0:
		bezs=[[bezpnt(p) for p in [[x1,y1],[x1+an2,y1-al2],[x2,y1],[x2+an2,y1+al2],[x2,y2],[x2-an2,y2+al2],[x1,y2],[x1-an2,y2-al2]]]]
	else:
		hipoX=math.sqrt(an2*an2+al2*al2)
		hipox=hipoX/(an2/h)
		hipoy=hipoX/(al2/h)
		bezs=[[bezpnt(p) for p in [[x1,y1],[x1,y1-hipox], [x1+an2,y1-al2-hipox],[x2,y1-hipox],[x2,y1],
			[x2+hipoy,y1],[x2+an2+hipoy,y1+al2],[x2+hipoy,y2],[x2,y2],
			[x2,y2+hipox],
			[x2-an2,y2+al2+hipox],[x1,y2+hipox],[x1,y2],
			[x1-hipoy,y2],[x1-an2-hipoy,y2-al2],[x1-hipoy,y1]]]]
	
	return [_("letter"),bezs,'','',True]

SHAPES2['Letter']={'tit':_('Letter'),
	'def2':shapeLetter,
	'objs':[
		{'t':'float','adj':[10,11.0,500.0,0.2],'digits':2,'label':_("Height")+' (px):'},
		{'t':'check','label':""               ,'tx':_("Create folding lines")}
	],'grp':_('Foldables')
}


def shapeMoon(x1,x2,y1,y2, objs):
	an,al=(x2-x1,y2-y1)
	an2,al2=(an/2.0,al/2.0)
	r=min(an,al)
	inix=(an-r)/2.0
	iniy=(al-r)/2.0
	r1=r/2.0
	cx,cy=(x1+an2,y1+al2)
	bezs=[]
	r2, displace = getVals(objs)
	
	chAdj(objs[0],None,r1)
	chAdj(objs[1],None,r1)

	multi=True
	if r2+displace<r1:
		bezs.append(bezsEllipse(x1+inix,x2-inix,y1+iniy,y2-iniy))
		bezs.append(bezsEllipse(x1+an2+displace-r2,x1+an2+displace+r2,  y1+al2-r2,y1+al2+r2))
	#	return [_("Moon"),bezs,extRadius,r1,True]
	else:
		X = ((displace*displace)-(r2*r2)+(r1*r1)) / (displace * 2.0)
		X2 = X-displace
		aa=math.degrees(math.acos(X/r1))
		bb=math.degrees(math.acos(X2/r2))
		bezs.append(bezsArc(x1+inix,x2-inix,y1+iniy,y2-iniy, aa, 360.0-aa,0))
		bezs.append(bezsArc(x1+an2-r2+displace,x1+an2+r2+displace ,y1+al2-r2,y1+al2+r2, bb, 360.0-bb,0))
		multi=False
	#	return [_("Moon"),bezs,extRadius,r1,0]
	return [_("Moon"),bezs,_('Exterior radius')+': ',r1,multi]

SHAPES2['moon']={
	'tit':_('Moon'),
	'def2':shapeMoon,
	'objs':[
		{'label':_("2nd radius")+':' ,'t':'float','adj':[5.0,2.0,1000.0,0.2],'digits':2},
		{'label':_("Center distance")+':','t':'float','adj':[9.0,2.0,200.0,0.2],'digits':2}
	],'grp':_('Others')

}


def polyStar2(x1,x2,y1,y2, objs,tipo='p'):
	an, al=(x2 - x1, y2 - y1)
	la = min(al,an)
	bezs=[]
	try:
		pnts = int(getVal(objs[0]))
		name=_('Polygon') if tipo=='p' else _('Star')
		name = name + str(pnts)
		v1 = getVal(objs[1])
		if tipo=='s':
			v5 = getVal(objs[2])
			if v5==0.0: v5=0.1
			starr2=100.0 / v5
		if tipo == 's': pnts = pnts * 2
		rot=360.0/pnts
		rd=la * 0.5
		if tipo=='p':
			corners=objs[2]['obj'].get_active()
			mrad = la / 2.0 * math.cos(math.radians(180.0 / pnts))
			bezs = polyRounded(rd,rot,pnts,v1,corners==0)
		else:
			mrad=(2.0*rd/starr2)*math.sin(math.pi/pnts)
			bezs = starRoundBez(rd,rd/starr2,rot,pnts,v1)
	except Exception,e:
		debugErr(e)
	bezs=centerBezs(bezs,x1,y1,an,al)
	return [name+str(pnts),bezs,_('Max. roundness')+':',mrad,True]

def shapePoly2(x1,x2,y1,y2, obj):
	n,bezs,a,b,c = polyStar2(x1,x2,y1,y2, obj,'p')
	return [n,bezs,a,b,c]

def shapeStar2(x1,x2,y1,y2, obj):
	return polyStar2(x1,x2,y1,y2, obj,'s')

SHAPES2['polygon']={'tit':_('Polygon'),'def2':shapePoly2,
	'objs':[
		{'label':_("Sides")+':'       ,'t':'float','adj':[5,3,200,1],'digits':0},
		{'label':_("Roundness")+':'   ,'t':'float','adj':[0.2,0.0,200.0,0.2],'digits':2},
		{'label':_("Inscribed in")+':','t':'combo','vals':POLYSEL}
	],'grp':_('Circular')
}

SHAPES2['star']={'tit':_('Star'),'def2':shapeStar2,
	'objs':[
		{'label':_("Points")+':' ,'t':'float','adj':[5,3,200,1],'digits':0},
		{'label':_("Roundness")+':' ,'t':'float','adj':[2.0,0.0,200.0,0.2],'digits':2},
		{'label':sIntRadius ,'t':'float','adj':[50.0,2.0,200.0,0.2],'digits':2}
	],'grp':_('Circular')
}


def shapeRadRuler(x1,x2,y1,y2, objs):
	an, al=(x2 - x1, y2 - y1)
	Ra = min(an,al)/2.0
	Tot,sM,lM,Alt=getVals(objs)

	chAdj(objs[1],None,Ra)
	chAdj(objs[2],None,Ra)

	iR = 360.0 / Tot
	cx,cy=(x1+an/2.0,y1+al/2.0)
	bezs=[]
	for n in range(0,Tot):
		pP = pnt2d(cx+Ra,cy).rotdeg(iR*n,cx,cy)
		hh = lM if (n % Alt)==0 else sM
		pP2=pnt2d(cx+Ra-hh,cy).rotdeg(iR*n,cx,cy)
		bezs.append([bezpnt(pP),bezpnt(pP2)])
	return ["radialruler_"+str(Tot),bezs,_('Max. length')+':',Ra,False]

SHAPES2['radRuler']={'tit':_('Radial ruler'),
	'def2':shapeRadRuler,
	'objs':[
		{'label':_("Total marks")+':'      ,'t':'float','adj':[5,2,200,1],'digits':0},
		{'label':_("Short mark length")+':','t':'float','adj':[9.0,2.0,200.0,0.2],'digits':2},
		{'label':_("Long mark length")+':' ,'t':'float','adj':[19.0,2.0,200.0,0.2],'digits':2},
		{'label':_("Long mark every")+':'  ,'t':'float','adj':[5,1,200,1],'digits':0}
	],
	'grp':_('Rulers')
}


def shapeRay(x1,x2,y1,y2,objs):
	an,al=(x2-x1,y2-y1)
	p=an
	top=0
	p1=[]
	p2=[]
	v3=objs[0]['obj'].get_value()
	for n in range(1,int(v3+1)):
		p3=p/3
		p1.extend([[p,top],[p3*2/3*2,top+p]])
		p2.extend([[p3,top],[0,top+p]])
		top += p
		p=p3*2
	py = al/top
	del p1[-1]
	p2=reversed(p2)
	bezs=[bezpnt([p[0]+x1,p[1]*py+y1]) for p in p1]
	for p in p2:
		bezs.append(bezpnt([p[0]+x1,p[1]*py+y1]))
	return [_("Ray"),bezs,'',0,True]

SHAPES2['ray']={'tit':_('Ray'),
	'def2':shapeRay,
	'objs':[{'label':_("Parts")+':' ,'t':'float','adj':[3,2,200,1],'digits':0}]
	,'grp':_('Others')
}


def shapeRectSpikes2(x1,x2,y1,y2, objs):
	an,al=(x2-x1,y2-y1)
	bezs=[]
	p1=[]
	p2=[]
	p3=[]
	v1,v2=getVals(objs)
	if v1==0.0: v1=1.0
	v1=v1/2.0
	totX=int(an//(v1*2.0))
	totY=int(al//(v1*2.0))
	totY=int(al//(v1*2.0))
	inix=(an % (v1*2.0)) / 2.0
	iniy=(al % (v1*2.0)) / 2.0
	if inix>0: 
		p1.append([x1,y1])
		p2.append([x1,y2])
	for i in range(0,totX):
		p1.extend([[i*v1*2+inix+x1,y1],[i*v1*2+v1+inix+x1,y1-v2]])
		p2.extend([[i*v1*2+inix+x1,y2],[i*v1*2+v1+inix+x1,y2+v2]])
	p1.append([totX*v1*2+inix+x1,y1])
	p2.append([totX*v1*2+inix+x1,y2])
	if inix>0: p2.append([x2,y2])
	if iniy>0: p1.append([x2,y1])
	for i in range(0,totY):
		p1.extend([[x2, i*v1*2+iniy+y1],[x2+v2, i*v1*2+v1+iniy+y1]])
		p3.extend([[x1, i*v1*2+iniy+y1],[x1-v2, i*v1*2+v1+iniy+y1]])
	p1.append([x2,   totY*v1*2+iniy+y1])
	p3.append([x1,   totY*v1*2+iniy+y1])
	p2=reversed(p2)
	p3=reversed(p3)
	bezs=[bezpnt([p[0],p[1]]) for p in p1]
	for p in p2:bezs.append(bezpnt([p[0],p[1]]))
	for p in p3:bezs.append(bezpnt([p[0],p[1]]))
	return [_("RectSpikes"),bezs,'',0,True]	

SHAPES2['RectSpikes']={'tit':_('Rectangle spikes'),
	'def2':shapeRectSpikes2,
	'objs':[
		{'label':_("Width")+':'  ,'t':'float','adj':[10.0,2.0,400.0,0.2],'digits':2},
		{'label':_("Height")+':' ,'t':'float','adj':[10.0,2.0,400.0,0.2],'digits':2}
	],'grp':_('Rectangular')
}


def shapeRomb2(x1,x2,y1,y2, objs):
	rad,Type=getVals(objs)
	corners=Type
	name=_('rhomboid')
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an * 0.5,al * 0.5)
	la = min(an,al)
	rad2 = rad * 0.5
	ll=math.sqrt(an2 * an2 + al2 * al2)*4
	mrad=(an*al)/ll
	if rad==0:
		bezs=[bezpnt(p) for p in [[x1+an2,y1], [x1,y1+al2], [x1+an2,y2], [x2,y1+al2]]]
	# chamfer
	else:
		if corners==1:
			name+=_('Chamfer')
			bezs=[bezpnt(p) for p in [[x1+an2-rad2,y1],[x1+an2+rad2,y1],[x2,y1+al2-rad2],[x2,y1+al2+rad2],[x1+an2+rad2,y2],[x1+an2-rad2,y2],[x1,y1+al2+rad2],[x1,y1+al2-rad2]]]
		elif corners==0:
			name+=_('Rounded')
			bezs=[]
			arc1=arcLinesBez(pnt2d(0,an2),pnt2d(-al2,0),pnt2d(al2,0),rad)
			arc2=arcLinesBez(pnt2d(0,al2),pnt2d(-an2,0),pnt2d(an2,0),rad)
			bezs.extend(rotArcBez(arc1,90)+rotArcBez(arc2,0)+rotArcBez(arc1,270)+rotArcBez(arc2,180))
			for bez in bezs: bez.translate(x1+an/2.0, y1+al/2.0)
	return [name,bezs,_('Max. roundness:'),mrad,True]

SHAPES2['romb']={'tit':_('Rhombus'),
	'def2':shapeRomb2,
	'objs':[
		{'label':_("Roundness")+':','t':'float','adj':[0.0,0.0,400.0,0.2],'digits':2},
		{'label':_("Type")+':'     ,'t':'radio','vals':CORNERSROMB}
	],'grp':_('Others')
}


def shapeRuler2(x1,x2,y1,y2, objs):
	an, al=(x2 - x1, y2 - y1)
	v6,v1,v2,v3,v5=getVals(objs)
	name="ruler_"
	bezs=[]
	if v6==0:
		name+='h'
		tot=int(an/v1)
		for n in range(tot):
			longM = n % v5
			hh = v3 if longM==0 else v2
			bezs.append([bezpnt([x1+n*v1,y1]),bezpnt([x1+n*v1,y1+hh])])
	else:
		name+='v'
		tot=int(al/v1)
		for n in range(tot):
			longM = n % v5
			hh = v3 if longM==0 else v2
			bezs.append([bezpnt([x1,y1+n*v1]),bezpnt([x1+hh,y1+n*v1])])
	return [name,bezs,_('Marks')+':',tot,False]

SHAPES2['Ruler']={'tit':_('Ruler'),
	'def2':shapeRuler2,
	'objs':[
		{'label':_("Direction")+':'        ,'t':'radio','vals':[[_("Horizontal"),0],[_("Vertical"),1]]},
		{'label':_("Marks separation")+':' ,'t':'float','adj':[5.0,2.0,200.0,0.2],'digits':2},
		{'label':_("Short mark length")+':','t':'float','adj':[9.0,2.0,200.0,0.2],'digits':2},
		{'label':_("Long mark length")+':','t':'float','adj':[19.0,2.0,200.0,0.2],'digits':2},
		{'label':_("Long mark every")+':','t':'float','adj':[5,0,200,1],'digits':0}
	],
	'grp':_('Rulers')
}


def shapeSpiral2(x1,x2,y1,y2, objs):
	an, al=(x2 - x1, y2 - y1)
	al2=al*0.5;
	bezs=[]
	vB=varBez
	tx1=''
	tx2=''
	type='coil'
	sType,turns,v5=getVals(objs)
	if sType in [0,1]:
		enableObj(objs[1],True)
		enableObj(objs[2],False)
	else:
		enableObj(objs[1],False)
		enableObj(objs[2],True)
	if sType==0:
		pp=an/3
		if pp*4>al: pp=al/4
		inipp=pp
		sx, sy =((an-pp*3)/2,(al-pp*4)/2)
		ty=0
		tx=pp
		for n in range(int(turns)):
			pp2, pp3, pp4=(pp*2, pp*3, pp*4)
			bzs=[bezpnt([0,0],None,[pp2*vB,0]), bezpnt([pp2,pp2],[pp2,pp2-pp2*vB],[pp2,pp2+pp2*vB]), bezpnt([0,pp4],[pp2*vB,pp4],[-pp*vB,pp4]), bezpnt([-pp,pp3],[-pp,pp3+pp*vB],[-pp,pp3-pp*vB]), bezpnt([0,pp2],[-pp*vB,pp2])]
			bzs=[p.translate(0,ty) for p in bzs]
			bezs.extend(bzs)
			ty+=pp*2
			tx=pp
			pp=pp/4
			tx-=pp
		bezs=[p.translate(x1+sx+inipp,y1+sy) for p in bezs]
		type="archim"
	elif sType==1:
		h = int(turns) * 2
		prop = min(an,al)
		Inc = prop/h
		tx1,tx2=(_('Turns distance')+':',Inc)
	elif sType==2:
		turns=int((min(al,an)/(v5*2)))
		h = int(turns) * 2
		prop=min(an,al)
		Inc = v5
		tx1,tx2=(_('Number of turns')+':',turns)
	if sType>0:
		p2 = prop / 2.0
		i2 = Inc/2.0
		w2 = an/2.0
		for n in range(int(turns)):
			nI = n*Inc
			bzs=[
				bezpnt([w2, al2 - nI],None,[w2 + (i2+nI) * vB, al2-nI]),
				bezpnt([w2+i2+nI,al2+i2],[w2+i2+nI, al2+i2-vB*(i2+nI)]),
				bezpnt([w2+i2+nI,al2+i2],None, [w2+i2+nI,al2+i2+vB*(i2+nI)]),
				bezpnt([w2, al2+nI+Inc],[w2+(i2+nI)*vB, al2+nI+Inc]),
				bezpnt([w2, al2+nI+Inc],None,[w2-(Inc+nI)*vB, al2+nI+Inc]),
				bezpnt([w2-nI-Inc,al2],[w2-nI-Inc, al2 +(nI+Inc)*vB]),
				bezpnt([w2-nI-Inc,al2],None,[w2 - nI-Inc, al2 -(nI+Inc)*vB]),
				bezpnt([w2,  al2-(nI+Inc)],[w2 - (nI+Inc)*vB, al2-(nI+Inc)])
			]
			bezs.extend(bzs)
		bezs=[p.translate(x1,y1) for p in bezs]
	name = _('spiral')+type+str(int(turns))
	return [name,bezs,tx1,tx2,False]

oppSpiral=[[_("Logarithmic"),0],[_("Coil-fixed count"),1],[_("Coil-by turns distance"),2]]

SHAPES2['spiral']={'tit':_('Spiral'),
	'def2':shapeSpiral2,
	'objs':[
		{'label':_("Type")+':'          ,'t':'radio','vals':oppSpiral},
		{'label':_("Turns")+':'         ,'t':'float','adj':[5,2,200,1],'digits':0},
		{'label':_("Turns distance")+':','t':'float','adj':[9.0,2.0,200.0,0.2],'digits':2}
	],
	'grp':_('Others')
}


def computeDpt(r1, r2, theta):
	dpt_sin = math.pow(r1*math.sin(theta), 2)
	dpt_cos = math.pow(r2*math.cos(theta), 2)
	return math.sqrt(dpt_sin + dpt_cos)

def elliVerts(r1,r2,n):
	theta = 0.0
	twoPi = math.pi*2.0
	deltaTheta = 0.01
	numIntegrals = math.floor(twoPi/deltaTheta)
	circ=0.0
	dpt=0.0
	i=0
	while(i<numIntegrals):
		theta += i*deltaTheta
		dpt = computeDpt( r1, r2, theta)
		circ += dpt
		i=i+1
	nextPoint = 0
	run = 0.0
	theta = 0.0
	pnts=[]
	i = 0
	while(i<numIntegrals):
		theta += deltaTheta
		subIntegral = n*run/circ
		if (int(subIntegral) >= nextPoint):
			pnts.append([r1 * math.cos(theta),r2 * math.sin(theta)])
			nextPoint+=1
		run += computeDpt(r1, r2, theta)
		i+=1
	return pnts

def spikeElliStar(p1,p2,height):
	pp=pnt2d(0,height)
	pcent=pnt2d((p1.x+p2.x)/2,(p1.y+p2.y)/2)
	deltaY = p2.y - p1.y
	deltaX = p2.x - p1.x

	angleInDegrees = math.atan(deltaY / deltaX) * 180 / math.pi
	if ((p1.y>p2.y) and (p1.x<p2.x)):
		angleInDegrees = 180 + angleInDegrees
	elif ((p1.y<p2.y) and (p1.x<p2.x)):
		angleInDegrees = 180 + angleInDegrees

	pp.rotdeg(angleInDegrees)
	pp.translate(pcent.x,pcent.y)
	return pp

def shapeElliStar2(x1,x2,y1,y2,objs):
	an=(x2-x1) * 0.5
	al=(y2-y1) * 0.5
	bezs=[]
	maxRad=min(an,al)
	v1=getVal(objs[1])
	v3=getVal(objs[0])
	msgTit=""
	msg=maxRad
	pts=elliVerts(an-v1,al-v1,v3)
	for n in range(len(pts)-1):
		p1= pnt2d(pts[n][0],pts[n][1])
		p2= pnt2d(pts[n+1][0],pts[n+1][1])
		pp=spikeElliStar(p1,p2,v1)
		bezs.append(bezpnt(pts[n]))
		bezs.append(bezpnt(pp))
	p1= pnt2d(pts[len(pts)-1][0],pts[len(pts)-1][1])
	p2= pnt2d(pts[0][0],pts[0][1])
	pp=spikeElliStar(p1,p2,v1)
	bezs.append(bezpnt(p1))
	bezs.append(bezpnt(pp))
	bezs=centerBezs(bezs,x1,y1,(x2-x1),(y2-y1))
	return [_("EllipStar")+str(v3),bezs,msgTit,msg,True]

def shapeElliPoly(x1,x2,y1,y2, v1,v2,v3,v5,v4,v6):
	an=(x2-x1)/2.0
	al=(y2-y1)/2.0
	bezs=[]
	msgTit=""
	msg=""
	pts=elliVerts(an,al,v3)
	for n in pts: bezs.append(bezpnt(n))
	bezs=centerBezs(bezs,x1,y1,(x2-x1),(y2-y1))
	return [_("EllipsPoly")+str(v3),bezs,msgTit,msg,True]

def shapeElliPoly(x1,x2,y1,y2, objs):
	an=(x2-x1)*0.5
	al=(y2-y1)*0.5
	maxRad=min(an,al)
	v3=getVal(objs[0])
	bezs=[]
	msgTit=""
	msg="" #maxRad
	pts=elliVerts(an,al,v3)
	for n in pts: bezs.append(bezpnt(n))
	bezs=centerBezs(bezs,x1,y1,(x2-x1),(y2-y1))
	return [_("EllipsPoly")+str(v3),bezs,msgTit,msg,True]

SHAPES2['ellistar']={'tit':_('Star ellipse'),
	'def2':shapeElliStar2,
	'objs':[
		{'label':_("Points")+':' ,'t':'float','adj':[5,3,200,1],'digits':0},
		{'label':_("Points height")+':','t':'float','adj':[9.0,1.0,200.0,0.2],'digits':2}
	],'grp':_('Circular')
}
SHAPES2['ellipoly']={'tit':_('Polygon ellipse'),
	'def2':shapeElliPoly,
	'objs':[{'label':_("Points")+':' ,'t':'float','adj':[5,3,200,1],'digits':0}],'grp':_('Circular')
}


def shapeTriIso(x1,x2,y1,y2, objs):
	name=_('isosceles')
	v6 = getRadioIndex(objs[0])
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an/2,al/2)
	name+=['top','bottom','left','right'][v6]
	bzs=[[[x1,y1],[x2,y1],[x1+an2,y2]], [[x1+an2,y1],[x1,y2],[x2,y2]], [[x1,y1],[x1,y2],[x2,y1+al2]], [[x2,y1],[x2,y2],[x1,y1+al2]]]
	bezs=[bezpnt(n) for n in bzs[v6]]
	return [name,bezs,'',0,True]

def shapeTriRgt(x1,x2,y1,y2, objs):
	name=_('rightTri')
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an/2,al/2)
	v6 = getRadioIndex(objs[0])
	name+=['tl','bl','tr','br'][v6]
	bzs=[[[x1,y1],[x2,y1],[x1,y2]], [[x1,y1],[x1,y2],[x2,y2]], [[x1,y1],[x2,y1],[x2,y2]], [[x1,y2],[x2,y2],[x2,y1]]]
	bezs=[bezpnt(n) for n in bzs[v6]]
	return [name,bezs,'',0,True]

rightPos=[[_('Top')+'-'+_('Left'),0],[_('Bottom')+'-'+_('Left'),1],[_('Top')+'-'+_('Right'),2],[_('Bottom')+'-'+_('Right'),3]]

SHAPES2['triIso']={'tit':_('Triangle Isosceles'),'def2':shapeTriIso,'objs':[{'t':'radio','vals':ArrowSEL,'label':_("Base position")+':'}],'grp':_('Triangles')}
SHAPES2['triRight']={'tit':_('Right Triangle'),'def2':shapeTriRgt,'objs':[{'t':'radio','vals':rightPos,'label':_("Right angle position")+':'}],'grp':_('Triangles')}
#--------------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------------
#LINE 596 start

try:
	SHAPES2=collections.OrderedDict(sorted(SHAPES2.items(), key=lambda t: t[1]['tit']))
except Exception,e:
	debug('Your distribution don''t suport collections.OrderedDict')

	
class sVecUtls(object):
	pnts=[]
	pntsbak=[]
	prevClosed=False
	thispath=None
	name='cuad'
	change=True
	selBak=[]
	tabs=[]
	ui=drawUi()

	tabTits=[_('Shape'),_('Selection'),_('Fill and border'),_('Transforms')]
	def __init__(self, runmode, img):
		self.img = img
		if runmode == RUN_INTERACTIVE:
			try:
				self.showDialog()
			except Exception,e:
				debugErr(e)
		elif runmode == RUN_WITH_LAST_VALS:
			self.showDialog()
		elif runmode == RUN_NONINTERACTIVE:
			return

	def addCellsInfo(self, txLab, iniCell, row, val, maxValue, name):
		self.ui.addRows(self.ui.addLabel(txLab), self.tabs[1], iniCell, iniCell+1, row, row+1)
		este=self.ui.addRows(gtk.SpinButton(gtk.Adjustment(val,0,maxValue,1),0.0,0),self.tabs[1],iniCell+1,iniCell+2,row,row+1)
		este.set_name(name)
		este.connect("activate",self.evalSpin,'activate')
		esteFn=este.connect("changed", self.chDim)
		return [este,esteFn]

	def numF(self,n):
		if n=='w': n=self.img.width
		if n=='h': n=self.img.height
		return n

	def setVal(self,obj,lP):
		if gimpshelf.shelf.has_key(pathcreator_key):
			defs=gimpshelf.shelf[pathcreator_key]
			if lP in defs:
				for n in range(0,len(self.Objs)):
					try:
						obj=self.Objs[n]['obj']
						if type(obj) is gtk.SpinButton: obj.set_value(defs[lP][n])
						if type(obj) is list: obj[defs[lP][n]].set_active(True)
						if type(obj) is gtk.ComboBox: obj.set_active(defs[lP][n])
					except Exception,e:
						debugErr(e)

	def chShape(self, widget):
		lP=self.getShape() #self.ui.getModelVal(widget)
		objs=SHAPES2[lP]['objs']
		row=0
		self.Objs=[]
		self.change = False
		for n in self.tab2.children(): n.destroy()
		for n in objs:
			T, lab=(n['t'],n['label'])
			lb = None
			if T=='tit':    ob=self.ui.addObjs([[self.ui.addLabel(lab,0,0.5),0,3,row,row+1]],self.tab2)
			if T=='float':
				adj=n['adj'] # adj 4 valores, inc, decimals
				obj=gtk.SpinButton(gtk.Adjustment(self.numF(adj[0]),self.numF(adj[1]),self.numF(adj[2]),self.numF(adj[3])),0.0,n['digits'])
			if T=='combo': obj=self.ui.makeCombo(n['vals'])
			if T=='check': lb,ob=self.ui.addObjs([[lab,0,1,row,row+1],[gtk.CheckButton(n['tx']),1,2,row,row+1,"toggled",self.chPath]],self.tab2)
			if T in ['float','combo']: lb, ob = self.ui.addObjs([[lab, 0, 1, row, row+1],[obj,1,2,row,row+1,"changed",self.chPath]],self.tab2)

			if T=='radio':
				c = 1
				tabla = self.ui.table(1,len(n['vals'])) if 'dir' in n else self.tab2
				r = 0 if 'dir' in n else row
				lb=self.ui.addObjs([[lab,0,1,row,row+1]],self.tab2)
				btn = None
				ob=[]
				for v in n['vals']:
					btn = gtk.RadioButton(btn,v[0])
					ob.extend(self.ui.addObjs([[btn, c, c+1, r, r+1, "toggled", self.chPath, v[1]]], tabla))
					if 'dir' in n:
						c += 1
					else:
						r += 1
				if 'dir' in n:
					self.ui.addObjs([[tabla, 1, 2, row, row+1]],self.tab2)
				row = r+1
			if T != 'tit':
				self.Objs.append({'obj':ob,'lb':lb})
				#self.Objs.append(ob)
				self.setVal(ob,lP)
			row += 1
		if 'img' in SHAPES2[lP]:
			imHlp=SHAPES2[lP]['img']
			# si es array es que se asigna a uno de los objetos
			debug(type(imHlp))
			#if type(imHlp)==dict:
			if type(imHlp)==list:
				debug(imHlp[0])
				pthImg=shapesImgPath + imHlp[1][imHlp[0]]
			else:
				pthImg=shapesImgPath + imHlp
			self.image = gtk.Image()
			self.image.set_from_file(pthImg)
			self.ui.addRows(self.image, self.tab2, 0, 2, row, self.maxRows+1)
			self.image.show()
		#add debug labels
		self.infoETit=self.ui.addRows(self.ui.addLabel('',0.0,1.0), self.tab2, 0, 2, row, self.maxRows+1)
		self.setLabels()
		# asignar valores
		defVals=None
		if gimpshelf.shelf.has_key(pathcreator_key):
			defs=gimpshelf.shelf[pathcreator_key]
			if lP in defs:
				defVals=defs[lP]
		self.change = True
		self.chPath(widget)

	def tabTransform(self, tab):
		r=0
		lb,self.shapeRot,r=self.ui.addObjs([[_('Rotation')+':',0,2,r,r+1],[gtk.SpinButton(gtk.Adjustment(0,-360,360,1),0.0,0),2,4,r,r+1,"changed",self.chPath],r+1],tab)
		lb,lb2,self.skewX,r=self.ui.addObjs([[self.ui.addLabel(_('Skew')+':',0.0),0,4,r,r+1],['X:',0,1,r+1,r+2],[gtk.SpinButton(gtk.Adjustment(0,-360,360,1),0.0,0),1,2,r+1,r+2,"changed",self.chPath],r+1],tab)
		lb,self.skewY,r=self.ui.addObjs([['Y:',2,3,r,r+1],[gtk.SpinButton(gtk.Adjustment(0,-360,360,1),0.0,0),3,4,r,r+1,"changed",self.chPath],r+1],tab)
		self.mirrorX,self.mirrorY=self.ui.addObjs([[gtk.CheckButton(_("Mirror X")),2,4,r,r+1,"toggled",self.chPath],[gtk.CheckButton(_("Mirror Y")),2,4,r+1,r+2,"toggled", self.chPath]],tab)
		r+=2
		lb,lb2,self.RandMin,lb3,self.RandMax=self.ui.addObjs(
			[[self.ui.addLabel(_('Add random')+':'),0,4,r,r+1],
			[_('From')+':',0,1,r+1,r+2],[gtk.SpinButton(gtk.Adjustment(0.0,-100.0,100.0,0.2,1.0),0.0,2),1,2,r+1,r+2,"changed",self.chPath],
			[_('To')+':',2,3,r+1,r+2],[gtk.SpinButton(gtk.Adjustment(0.0,-100.0,100.0,0.2,1.0),0.0,2),3,4,r+1,r+2,"changed",self.chPath]]
		,tab)

	def tabSelection(self, tab):
		row = 0
		self.ui.addRows(self.ui.addLabel(_('Selection details:'),0), tab, 6, 11, row, row+1)
		row+=1
		non_empty, x1, y1, x2, y2 = pdb.gimp_selection_bounds(self.img)
		if non_empty==False: x1,y1,x2,y2=(0,0,self.img.width,self.img.height)
		self.iW,self.iWFn=self.addCellsInfo(_('Width')+':',6, row, x2-x1, self.img.width, 'iW')
		self.iH,self.iHFn=self.addCellsInfo(_('Height')+':',8, row, y2-y1, self.img.height, 'iH')
		row=row+1
		self.iL,self.iLFn=self.addCellsInfo(_('Left')+':',6, row, x1, self.img.width, 'iL')
		self.iR,self.iRFn=self.addCellsInfo(_('Right'+':'),8, row, x2, self.img.width, 'iR')
		row+=1
		self.iT,self.iTFn=self.addCellsInfo(_('Top')+':',6, row, y1, self.img.height, 'iT')
		self.iB,self.iBFn=self.addCellsInfo(_('Bottom')+':',8, row, y2, self.img.height, 'iB')
		row+=1
		self.ui.addRows(self.ui.addLabel(_('Shrink/Grow')), tab, 6, 9, row, row+1)
		self.shrinkGrow=self.ui.addRows(gtk.SpinButton(gtk.Adjustment(0, -200, 200, 1), 0.0, 0), tab, 9, 10, row, row+1, "changed", self.chPath)
		row += 1
		self.squaSel = self.ui.addRows(gtk.CheckButton(_("Square selection")), tab, 0, 10, row, row+1,"toggled", self.chPath)

	def addCol(self,tv,title,renderer,pos,postx,tip,sortCol=None):
		col = gtk.TreeViewColumn(title, renderer, text=postx)
		label = gtk.Label(title)
		col.set_widget(label)
		label.show()
		self.ui.addTip(label,tip)
		tv.insert_column(col,pos)
		if sortCol != None : col.set_sort_column_id(sortCol)

	def getShape(self):
		sel = self.tv.get_selection()

		model, iter = sel.get_selected()
		if iter==None:
			for n in range(len(model)):
				if model[n][1] != '':
					return model[n][1]
				else:
					self.tv.expand_row(n, False)
					hijo = model[n].iterchildren().next()
					try:
						sel.select_iter(hijo.iter)
					except Exception,e:
						debugErr(e)
					return hijo[1]
		return model.get_value(iter,1)

	def addTV(self,name):
		treestore = gtk.TreeStore(str,str)
		tv = gtk.TreeView(treestore)
		self.tvcolumn = gtk.TreeViewColumn(_('Shapes'))
		tv.append_column(self.tvcolumn)
		self.cell = gtk.CellRendererText()
		self.tvcolumn.pack_start(self.cell, True)
		self.tvcolumn.add_attribute(self.cell, 'text', 0)
		self.tvcolumn.set_sort_column_id(0)
		setProps(tv,{'search-column':0,'rules-hint':True,'reorderable':True,'show-expanders':True,'enable-tree-lines':True})
		tv.set_grid_lines(gtk.TREE_VIEW_GRID_LINES_BOTH)
		self.tv = tv
		select = self.tv.get_selection()
		select.set_mode(gtk.SELECTION_SINGLE)
		sW = gtk.ScrolledWindow()
		for n in [gtk.SHADOW_IN,gtk.SHADOW_ETCHED_IN]: sW.set_shadow_type(n)
		sW.add(tv)
		sW.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_AUTOMATIC)
		longName = ''
		maxRows = 0
		for n in SHAPES2:
			tit = SHAPES2[n]['tit']
			iter = None
			if 'grp' in SHAPES2[n]:
				grp = SHAPES2[n]['grp']
				if len(treestore)>0:
					for i in range(len(treestore)):
						it=treestore.get_iter(i)
						if treestore.get_value(it,0)==grp:
							iter=it
							break
				if iter==None: iter = treestore.append(None,[grp,''])
			treestore.append(iter,[tit,n])
			maxRows = max(maxRows,len(SHAPES2[n]['objs']))
			if len(tit)>len(longName): longName=tit
		try:
			style = tv.get_style().copy()
			tv.set_style(style)
		except Exception,e:
			debug(e)
		self.maxRows=maxRows+1
		tv.show()
		sW.show()
		self.ui.addRows(sW, self.table, 0, 1, 0, 4)
		self.ui.addRows(self.ui.addLabel('_'*(len(longName)+7)), self.table, 0, 1, 1, 2)
		return (treestore,tv,sW)

	def showDialog(self):
		self.change=False
		if self.thispath==None:
			self.thispath = pdb.gimp_vectors_new(self.img, self.name)
			pdb.gimp_image_add_vectors(self.img, self.thispath, 0)
		self.dialog = gimpui.Dialog("Shapes creator", "rotdlg")
		self.dialog.set_keep_above(True)
		self.dialog.set_position(gtk.WIN_POS_CENTER)
		self.table=self.ui.table(3,1,False)
		self.btnSel,self.btnadd=self.ui.addObjs([[gtk.Button(_("Update selection")),1,2,2,3,"clicked",self.updselbtn],[gtk.Button(_("Add shape")), 1, 2, 3, 4,"clicked", self.addbtn]],self.table)

		self.nB = gtk.Notebook()
		self.ui.addRows(self.nB, self.table, 1, 2, 0, 2)
		for n in range(0,len(self.tabTits)):
			self.tabs.append(self.ui.table(6, 2, False))
			self.nB.append_page(self.tabs[n], gtk.Label(self.tabTits[n]))
		self.tab2=self.ui.addRows(self.ui.table(1, 2, False,2,2), self.tabs[0], 1, 2, 0, 7)
		tS,tv,sW=self.addTV('a')

		row=0
		row += 1

		self.tabSelection(self.tabs[1])
		self.tabSelFill(self.tabs[2])
		self.tabTransform(self.tabs[3])

		for wg in [self.shapeRot,self.shrinkGrow,self.skewX,self.skewY]: wg.connect("activate",self.evalSpin,'activate')
		self.dialog.vbox.hbox1 = gtk.HBox(False, 7)
		self.dialog.vbox.hbox1.show()
		self.dialog.vbox.pack_start(self.dialog.vbox.hbox1, True, True, 3)
		self.dialog.vbox.hbox1.pack_start(self.table, True, True, 3)
		cancel_button = self.dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
		cancel_button.connect("clicked", self.kobtn)

		flds=SHAPES2[SHAPES2.keys()[0]]
		if gimpshelf.shelf.has_key(pathcreator_key):
			lastshape=gimpshelf.shelf[pathcreator_key]['lastshape']
			tS.foreach(self.match_value_cb, (lastshape,tv))
		self.tv.get_selection().connect("changed", self.chShape)
		try:
			self.dialog.show()
		except Exception,e:
			debug(e)

		self.chShape(None)
		self.dialog.run()

	def match_value_cb(self, model, path, iter, data):
		if model.get_value(iter, 1) == data[0]:
			data[1].expand_row(path[0], True)
			data[1].set_cursor(path)
			return True
		return False

	def checkSel(self, widget, data=None):
		self.selOpp.set_sensitive(widget.get_active())

	def evalSpin(self, widget, data=None):
		s=widget.get_text()
		s=s.replace('W',str(self.img.width))
		s=s.replace('H',str(self.img.height))
		widget.set_value(eval(s))

	def chSizeVal(self, obj, objSignal, value):
		# disable the on change function, change the value and enable the function again
		obj.disconnect(objSignal)
		obj.set_value(value)
		objSignal = obj.connect("changed", self.chDim)
		return objSignal

	def chDim(self, widget):
		este = widget.get_name()
		iLv,iRv,iWv,iHv,iTv,iBv=self.ui.getValues([self.iL,self.iR,self.iW,self.iH,self.iT,self.iB])
		self.change=False
		if este=='iW': self.iRFn=self.chSizeVal(self.iR,self.iRFn,iWv + iLv)
		if este=='iH': self.iBFn=self.chSizeVal(self.iB,self.iBFn,iHv + iTv)
		if este=='iR' or este=='iL': self.iWFn=self.chSizeVal(self.iW,self.iWFn,iRv + iLv)
		if este=='iT' or este=='iB': self.iHFn=self.chSizeVal(self.iH,self.iHFn,iBv + iTv)
		self.change=True
		self.chPath(widget)

	def transformGimpPath(self,gp,x1,x2,y1,y2):
		rotShape, skX, skY=self.ui.getValues([self.shapeRot,self.skewX,self.skewY])
		mirrorX=self.mirrorX.get_active()
		mirrorY=self.mirrorY.get_active()
		cx,cy=(x1+(x2-x1)/2.0,y1+(y2-y1)/2.0)
		if rotShape!=0.0: gp.rotdeg(rotShape,cx,cy)
		if (skX+skY)>0: gp.skew(skX,skY,cx,cy)
		sx,sy=(-1 if mirrorX else 1,-1 if mirrorY else 1)
		if mirrorX or mirrorY:
			gp.translate(-cx if mirrorX else 0,-cy if mirrorY else 0)
			gp.scale(sx,sy)
			gp.translate(cx if mirrorX else 0,cy if mirrorY else 0)

	def rand(self,pnts):
		rMin,rMax=self.ui.getValues([self.RandMin,self.RandMax])
		if rMin==0 and rMax==0:
			return pnts
		for n in range(0,len(pnts)):
			pnts[n]=pnts[n]+random.uniform(rMin,rMax)
		return pnts

	def linear(self,pnts):
		for n in range(0,len(pnts)/6):
			pnts[n*6]=pnts[n*6+2]
			pnts[n*6+1]=pnts[n*6+3]
			pnts[n*6+4]=pnts[n*6+2]
			pnts[n*6+5]=pnts[n*6+3]
		return pnts

	def chPath(self, widget):
		if self.change==False: return

		lP=self.getShape()
		non_empty, x1, y1, x2, y2 = pdb.gimp_selection_bounds(self.img)
		if non_empty==False: x1,y1,x2,y2=(0,0,self.img.width,self.img.height)
		x1, x2, y1, y2, sg = self.ui.getValues([self.iL,self.iR,self.iT,self.iB,self.shrinkGrow])
		if sg<>0:
			x1-=sg
			x2+=sg
			y1-=sg
			y2+=sg
		if self.squaSel.get_active()==True:
			an, al=(x2-x1, y2-y1)
			lado=min(an,al)
			if lado!=an:
				x1=x1+(an-lado) * 0.5
				x2=x2-(an-lado) * 0.5
			if lado!=al:
				y1=y1+(al-lado) * 0.5
				y2=y2-(al-lado) * 0.5
		bezs=[]
		pnts=[]
		shp=SHAPES2[lP]
		try:
			Def2=shp['def2']
			name,bezs,xtraTit,xtraVal,closed=Def2(x1,x2,y1,y2, self.Objs)

			if 'img' in SHAPES2[lP]:
				imHlp=SHAPES2[lP]['img']
				# si es array es que se asigna a uno de los objetos
				if type(imHlp)==list:
					obj=imHlp[0]
					pthImg=shapesImgPath + imHlp[1][0]
					vals=getVals(self.Objs)
					pthImg=shapesImgPath + imHlp[1][vals[imHlp[0]]]
				else:
					pthImg=shapesImgPath + imHlp
				self.image.set_from_file(pthImg)
			self.extraInfo(xtraTit,xtraVal)
		except Exception,e:
			debugErr(e)

		if type(bezs[0])==list:
			v = pdb.gimp_vectors_new(self.img, 'pppp')
			for n in bezs:
				gp = gimppath(n)
				self.transformGimpPath(gp,x1,x2,y1,y2)
				gp.compact()
		else:
			gp = gimppath(bezs)
			gp.compact()
			self.transformGimpPath(gp,x1,x2,y1,y2)
		pnts = gp.toGimpPath()
		self.pnts = self.rand(pnts)
		self.name = name
		
		# distintos
		if self.pntsbak<>self.pnts or self.prevClosed<>closed:
			if len(self.thispath.strokes)==1:
				pdb.gimp_vectors_remove_stroke(self.thispath, self.thispath.strokes[0].ID)
			else:
				vv=pdb.gimp_vectors_new(self.img, 'pppp')
				pdb.gimp_image_remove_vectors(self.img, self.thispath)
				pdb.gimp_image_add_vectors(self.img, vv, 0)
				self.thispath=vv
			if type(bezs[0])==list:
				for n in bezs:
					gp = gimppath(n)
					pnts = gp.toGimpPath()
					pnts = self.rand(pnts)
					pdb.gimp_vectors_stroke_new_from_points(v, 0,  len(pnts), pnts, closed)
				pdb.gimp_image_remove_vectors(self.img, self.thispath)
				pdb.gimp_image_add_vectors(self.img, v, 0)
				self.thispath=v
			else:
				try:
					if len(self.thispath.strokes)>0: pdb.gimp_vectors_remove_stroke(self.thispath, self.thispath.strokes[0].ID)
				except Exception,e:
					debugErr(str(e))
				pdb.gimp_vectors_stroke_new_from_points(self.thispath, 0, len(self.pnts), self.pnts, closed)
			self.thispath.name=name
			pdb.gimp_item_set_visible(self.thispath, True)
			self.pntsbak=self.pnts
			self.prevClosed=closed

	def setLabels(self):
		defvals = {}
		self.change = False
		ch_path = False
		if gimpshelf.shelf.has_key(pathcreator_key):
			defvals = gimpshelf.shelf[pathcreator_key]
			lP = self.getShape()
			if lP in defvals:
				vals = defvals[lP]
				ch_path = True
		if (ch_path): self.chPath(self)
		self.change=True

	def extraInfo(self,tit1,maxFloat,field=None):
		if isinstance(maxFloat, str) or isinstance(maxFloat, unicode):
			tx = maxFloat
		else:
			tx = '%.2f'%(maxFloat)
		self.infoETit.set_text(tit1+tx)

	def bakSelection(self):
		selection = pdb.gimp_image_get_selection(self.img)
		channel = pdb.gimp_selection_save(self.img)
		pdb.gimp_image_select_item(self.img, 2, channel)

	def tabSelFill(self,tab):
		row = 0
		self.ui.addRows(gtk.Label(_('Stroke path')+':'), self.tabs[2], 0, 1, row, row+1)
		self.selStroke = self.ui.addRows(self.ui.makeCombo(oppStro), self.tabs[2], 1, 2, row, row+1)
		row += 1

		self.ui.addRows(gtk.Label(_('Current brush')+':'), self.tabs[2], 0, 1, row, row+1)
		angle = pdb.gimp_context_get_brush_angle()
		aspect = pdb.gimp_context_get_brush_aspect_ratio()
		size = pdb.gimp_context_get_brush_size()
		descBr=pdb.gimp_context_get_brush()+'\n'+_("Angle"+': ')+str(angle)+'\n'+_("Aspect")+': '+str(aspect)+'\n'+_("Size")+': '+str(size)

		self.ui.addRows(gtk.Label(descBr), self.tabs[2], 1, 2, row, row+1)
		row += 1

		lb,self.fillFg=self.ui.addObjs([[_('Fill')+':',0,1,row,row+1],[self.ui.makeCombo(oppFill),1,2,row,row+1]],self.tabs[2])
		row += 1
		self.newLayer=self.ui.addRows(gtk.CheckButton(_("Add new layer for fill-stroke")), self.tabs[2], 0, 2, row, row+1)
		row += 1
		self.useSel=self.ui.addRows(gtk.CheckButton(_("Use as selection")), self.tabs[2], 0, 2, row, row+1,"toggled", self.checkSel)
		row += 1
		self.ui.addRows(gtk.Label(_('Operation')+':'), self.tabs[2], 0, 1, row, row+1)
		self.selOpp = self.ui.addRows(self.ui.makeCombo(oppSel), self.tabs[2], 1, 2, row, row+1)
		self.selOpp.set_sensitive(False)

	def selAndFill(self,widget):
		drawable = pdb.gimp_image_get_active_drawable(self.img)
		flush=False
		stroke=self.selStroke.get_active()
		fill=self.fillFg.get_active()
		if stroke>0 or fill>0:
			if self.newLayer.get_active()==True:
				layer=pdb.gimp_layer_new(self.img, self.img.width,self.img.height,1,'layer_'+self.name,100,0)
				pdb.gimp_image_insert_layer(self.img, layer, None, 0)
				drawable=layer
			channel = pdb.gimp_selection_save(self.img)
			pdb.gimp_selection_all(self.img)
			if stroke==1:
				pdb.gimp_edit_stroke_vectors(drawable, self.thispath)
			if fill>0:
				pdb.gimp_image_select_item(self.img, 2, self.thispath)
				if fill==3: fill=5
				pdb.gimp_edit_fill(drawable, fill-1)
			if stroke==2:
				pdb.gimp_selection_none(self.img)
				pdb.gimp_edit_stroke_vectors(drawable, self.thispath)
			pdb.gimp_image_select_item(self.img, 2, channel)
			if pdb.gimp_item_is_layer(drawable): pdb.gimp_image_set_active_layer(self.img, drawable)
			pdb.gimp_image_remove_channel(self.img, channel)
			drawable.flush()
		if self.useSel.get_active()==True: pdb.gimp_image_select_item(self.img, self.selOpp.get_active(), self.thispath)
		gimp.displays_flush()

	def getVal(self,obj):
		if type(obj) is gtk.SpinButton: return obj.get_value()
		if type(obj) is gtk.ComboBox: return obj.get_active()
		if type(obj) is list:
			if type(obj[0]) is gtk.RadioButton:
				return getRadioIndex(obj)
			return obj.get_active()
		return None

	def saveToShelf(self):
		lP=self.getShape()
		saveVals=[]
		for n in self.Objs: saveVals.append(gVal(n))
		defvals={}
		if gimpshelf.shelf.has_key(pathcreator_key): defvals=gimpshelf.shelf[pathcreator_key]
		defvals['lastshape']=lP
		defvals[lP]=saveVals
		gimpshelf.shelf[pathcreator_key] = defvals

	def addbtn(self, widget):
		self.saveToShelf()
		self.selAndFill(None)
		self.thispath = pdb.gimp_vectors_new(self.img, self.name)
		debug(self.thispath)
		pdb.gimp_image_add_vectors(self.img, self.thispath, 0)
		self.change=True
		self.pntsbak=[]
		self.chPath(widget)
		return False

	def updselbtn(self, widget):
		non_empty, x1, y1, x2, y2 = pdb.gimp_selection_bounds(self.img)
		if non_empty==False: x1,y1,x2,y2=(0,0,self.img.width,self.img.height)
		self.change=False
		self.iWFn=self.chSizeVal(self.iW, self.iWFn, x2-x1)
		self.iHFn=self.chSizeVal(self.iH, self.iHFn, y2-y1)
		self.iLFn=self.chSizeVal(self.iL, self.iLFn, x1)
		self.iRFn=self.chSizeVal(self.iR, self.iRFn, x2)
		self.iTFn=self.chSizeVal(self.iT, self.iTFn, y1)
		self.iBFn=self.chSizeVal(self.iB, self.iBFn, y2)
		self.change=True
		self.chPath(widget)
		return False

	def kobtn(self, widget):
		if pdb.gimp_item_is_valid(self.thispath):
			pdb.gimp_image_remove_vectors(self.img, self.thispath)

class ArakneShapeCreator(gimpplugin.plugin):
	def start(self):
		gimp.main(self.init, self.quit, self.query, self._run)
	def init(self):
		pass
	def quit(self):
		pass
	def query(self):
		cright = "jfgarcia"
		date = "2013-2015"
		plug_descr = _("Create paths centered on the current selection")
		plug_params = [(PDB_INT32, "run_mode", "Run mode"), (PDB_IMAGE, "image", "Input image"),]
		gimp.install_procedure("arakne_path_shape_creator5", plug_descr, plug_descr, "jfgarcia", cright, date, _("<Image>/Filters/Path/path shape creator..."), "RGB*, GRAY*", PLUGIN, plug_params,[])

	def arakne_path_shape_creator5(self, runmode, img):
		sVecUtls(runmode, img)

if __name__ == '__main__':
	ArakneShapeCreator().start()

# 628