/*
 * Decompiled with CFR 0.152.
 */
import com.jhlabs.image.GaussianFilter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;

public class Document {
    private PainterlyStyle painterlyStyle;
    private static final float[] sobelXMatrix = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};
    private static final float[] sobelYMatrix = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
    private BufferedImage source = null;
    private BufferedImage target;
    private BufferedImage writtenArea;
    private BufferedImage blurred = null;
    private SobelVector[] sobelVector = null;
    private List<StateChangeListener> _stateChangeListeners = new Vector<StateChangeListener>();
    private boolean doDrawDot = true;

    public Document() {
        this.setPredefinedStyle(PainterlyStyle.IMPRESSIONIST_STYLE);
    }

    public void selectSourceFile(String filename) {
        try {
            this.source = ImageIO.read(new File(filename));
            this.target = new BufferedImage(this.source.getWidth(), this.source.getHeight(), 2);
            this.writtenArea = new BufferedImage(this.source.getWidth(), this.source.getHeight(), 12);
            this.sobelVector = new SobelVector[this.source.getWidth() * this.source.getHeight()];
            int i = 0;
            while (i < this.sobelVector.length) {
                this.sobelVector[i] = new SobelVector();
                ++i;
            }
        }
        catch (Exception e) {
            this.source = null;
            this.target = null;
            this.sobelVector = null;
        }
    }

    public void saveDocument(String filename) {
        try {
            ImageIO.write((RenderedImage)this.target, "png", new File(filename));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private short doConvolution(int x, int y, BufferedImage source, float[] convolve) {
        short value = 0;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                try {
                    int intensity = new Color(source.getRGB(x + i - 1, y + j - 1)).getBlue();
                    value = (short)((float)value + (float)intensity * convolve[j * 3 + i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return value;
    }

    private void calculateSobelVectors(BufferedImage luma) {
        int width = luma.getWidth();
        int height = luma.getHeight();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                SobelVector v = this.sobelVector[y * width + x];
                v.x = this.doConvolution(x, y, luma, sobelXMatrix);
                v.y = this.doConvolution(x, y, luma, sobelYMatrix);
                ++x;
            }
            ++y;
        }
    }

    private void renderEdges() {
        float gradmag;
        int y;
        if (!this.getDrawEdges()) {
            return;
        }
        Graphics2D g = this.writtenArea.createGraphics();
        g.setBackground(Color.black);
        g.clearRect(0, 0, this.writtenArea.getWidth(), this.writtenArea.getHeight());
        BufferedImage sourceTmp = this.source;
        BufferedImage blackSource = new BufferedImage(this.source.getWidth(), this.source.getHeight(), 2);
        Graphics2D g2 = blackSource.createGraphics();
        g2.setBackground(Color.black);
        g2.clearRect(0, 0, blackSource.getWidth(), blackSource.getHeight());
        this.source = blackSource;
        float maxGradMag = Float.MIN_VALUE;
        int x = 0;
        while (x < this.source.getWidth()) {
            y = 0;
            while (y < this.source.getHeight()) {
                gradmag = this.getGradientMagnitude(new Point2D.Float(x, y));
                if (gradmag > maxGradMag) {
                    maxGradMag = gradmag;
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < this.source.getWidth()) {
            y = 0;
            while (y < this.source.getHeight()) {
                gradmag = this.getGradientMagnitude(new Point2D.Float(x, y));
                if (gradmag < maxGradMag * this.getEdgeThreshold() / 100.0f) {
                    SobelVector sV = this.sobelVector[y * this.source.getWidth() + x];
                    sV.x = 0;
                    sV.y = 0;
                }
                ++y;
            }
            ++x;
        }
        this.doDrawDot = false;
        this.paintLayer(2.0f);
        this.doDrawDot = true;
        this.source = sourceTmp;
    }

    public void doPainterly() {
        try {
            Graphics2D g = this.target.createGraphics();
            g.setBackground(Color.white);
            g.clearRect(0, 0, this.target.getWidth(), this.target.getHeight());
            g = this.writtenArea.createGraphics();
            g.setBackground(Color.black);
            g.clearRect(0, 0, this.writtenArea.getWidth(), this.writtenArea.getHeight());
            int i = this.getMaximumBrushSize();
            while (i > 1) {
                GaussianFilter gaussian = new GaussianFilter((float)i * this.getBlurFactor());
                this.blurred = gaussian.filter(this.source, null);
                BufferedImage luma = new BufferedImage(this.blurred.getWidth(), this.blurred.getHeight(), 10);
                luma.createGraphics().drawImage((Image)this.blurred, 0, 0, null);
                this.calculateSobelVectors(luma);
                this.paintLayer(i);
                i /= 2;
            }
            this.renderEdges();
            this.fireStateChangeEvent();
        }
        catch (Exception e) {
            Graphics2D g = this.target.createGraphics();
            g.setBackground(new Color(255, 255, 255));
            g.clearRect(0, 0, this.target.getWidth(), this.target.getHeight());
        }
    }

    private void paintLayer(float brushSize) {
        int grid = Math.round(this.getGridSize() * brushSize);
        int gridsqr = grid * grid;
        Vector<Point2D.Float> strokeList = new Vector<Point2D.Float>();
        int x = 0;
        while (x < this.source.getWidth()) {
            int y = 0;
            while (y < this.source.getHeight()) {
                float areaError = 0.0f;
                float worstError = Float.MIN_VALUE;
                int wEX = x;
                int wEY = y;
                int eY = y - grid / 2;
                while (eY < y + grid / 2) {
                    int eX = x - grid / 2;
                    while (eX < x + grid / 2) {
                        float difference;
                        int jitteredX = eX + (int)((Math.random() - 0.5) * (double)grid);
                        int jitteredY = eY + (int)((Math.random() - 0.5) * (double)grid);
                        if (jitteredX < 0) {
                            jitteredX = 0;
                        }
                        if (jitteredX >= this.source.getWidth()) {
                            jitteredX = this.source.getWidth() - 1;
                        }
                        if (jitteredY < 0) {
                            jitteredY = 0;
                        }
                        if (jitteredY >= this.source.getHeight()) {
                            jitteredY = this.source.getHeight() - 1;
                        }
                        if ((difference = this.getDifference(jitteredX, jitteredY)) > worstError) {
                            worstError = difference;
                            wEX = jitteredX;
                            wEY = jitteredY;
                        }
                        areaError += difference;
                        ++eX;
                    }
                    ++eY;
                }
                if ((areaError /= (float)gridsqr) > this.getThreshold()) {
                    strokeList.add(new Point2D.Float(wEX, wEY));
                }
                y += grid;
            }
            x += grid;
        }
        while (!strokeList.isEmpty()) {
            Point2D.Float obj = (Point2D.Float)strokeList.remove((int)Math.floor(Math.random() * (double)strokeList.size()));
            this.makeStroke(brushSize, obj);
        }
    }

    float clamp(float v, float l, float h) {
        if (v >= h) {
            v = h;
        }
        if (v <= l) {
            v = l;
        }
        return v;
    }

    int clamp(int v, int l, int h) {
        if (v >= h) {
            v = h;
        }
        if (v <= l) {
            v = l;
        }
        return v;
    }

    Color createStrokeColor(int x, int y) {
        Color temp = new Color(this.source.getRGB(x, y), true);
        if (this.doDrawDot) {
            Color baseStrokeColor = new Color(temp.getRed(), temp.getGreen(), temp.getBlue());
            float[] hsbvals = new float[3];
            Color.RGBtoHSB(baseStrokeColor.getRed(), baseStrokeColor.getGreen(), baseStrokeColor.getBlue(), hsbvals);
            hsbvals[0] = (float)((double)hsbvals[0] + (Math.random() - 0.5) * (double)this.getHueJitter());
            hsbvals[1] = (float)((double)hsbvals[1] + (Math.random() - 0.5) * (double)this.getSaturationJitter());
            hsbvals[2] = (float)((double)hsbvals[2] + (Math.random() - 0.5) * (double)this.getValueJitter());
            Color jitteredHSB = new Color(Color.HSBtoRGB(this.clamp(hsbvals[0], 0.0f, 1.0f), this.clamp(hsbvals[1], 0.0f, 1.0f), this.clamp(hsbvals[2], 0.0f, 1.0f)));
            Color jitteredRGB = new Color(this.clamp(jitteredHSB.getRed() + (int)((Math.random() - 0.5) * (double)this.getRedJitter()), 0, 255), this.clamp(jitteredHSB.getGreen() + (int)((Math.random() - 0.5) * (double)this.getGreenJitter()), 0, 255), this.clamp(jitteredHSB.getBlue() + (int)((Math.random() - 0.5) * (double)this.getBlueJitter()), 0, 255), this.getColorOpacity());
            return jitteredRGB;
        }
        return temp;
    }

    void renderStroke(BufferedImage t, Vector<Point2D.Float> path, Color strokeColor, float brushSize) {
        Point2D.Float initial = path.elementAt(0);
        Graphics2D g = t.createGraphics();
        g.getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(strokeColor);
        float halfBrush = 0.0f;
        if (path.size() > 1) {
            GeneralPath gp = new GeneralPath();
            gp.moveTo((int)(initial.x - halfBrush), (int)(initial.y - halfBrush));
            int i = 1;
            while (i < path.size() - 1) {
                Point2D.Float p1 = path.elementAt(i - 1);
                Point2D.Float p2 = path.elementAt(i);
                Point2D.Float p3 = path.elementAt(i + 1);
                gp.curveTo(p1.x - halfBrush, p1.y - halfBrush, p2.x - halfBrush, p2.y - halfBrush, p3.x - halfBrush, p3.y - halfBrush);
                ++i;
            }
            gp.lineTo(path.elementAt((int)(path.size() - 1)).x - halfBrush, path.elementAt((int)(path.size() - 1)).y - halfBrush);
            g.setStroke(new BasicStroke(brushSize));
            g.draw(gp);
        } else if (this.doDrawDot) {
            g.fillOval((int)(initial.x - halfBrush), (int)(initial.y - halfBrush), (int)brushSize, (int)brushSize);
        }
    }

    void makeStroke(float brushSize, Point2D.Float initial) {
        Vector<Point2D.Float> path = new Vector<Point2D.Float>();
        Point2D.Float current = initial;
        Point2D.Float lastDelta = new Point2D.Float(0.0f, 0.0f);
        Color strokeColor = this.createStrokeColor((int)current.getX(), (int)current.getY());
        path.add((Point2D.Float)current.clone());
        int i = 1;
        while (i < this.getMaximumStrokeLength()) {
            if (i > this.getMinimumStrokeLength() && this.getDifference((int)current.x, (int)current.y) < this.getDifference(new Color(this.source.getRGB((int)current.getX(), (int)current.getY()), true), strokeColor) || this.getGradientMagnitude(current) == 0.0f) break;
            Point2D.Float gradient = this.getGradientDirection(current);
            Point2D.Float delta = new Point2D.Float((float)(-gradient.getY()), (float)gradient.getX());
            if (lastDelta.getX() * delta.getX() + lastDelta.getY() * delta.getY() < 0.0) {
                delta.x = -delta.x;
                delta.y = -delta.y;
            }
            float deltaMag = (float)Math.sqrt(delta.x * delta.x + delta.y * delta.y);
            delta.x = this.getCurvatureFilter() * delta.x + (1.0f - this.getCurvatureFilter()) * lastDelta.x;
            delta.x /= deltaMag;
            delta.y = this.getCurvatureFilter() * delta.y + (1.0f - this.getCurvatureFilter()) * lastDelta.y;
            delta.y /= deltaMag;
            current.x += brushSize * delta.x;
            current.y += brushSize * delta.y;
            if (current.x < 0.0f || current.x >= (float)this.source.getWidth() || current.y < 0.0f || current.y >= (float)this.source.getHeight()) break;
            lastDelta = delta;
            path.add((Point2D.Float)current.clone());
            ++i;
        }
        this.renderStroke(this.target, path, strokeColor, brushSize);
        this.renderStroke(this.writtenArea, path, Color.white, brushSize);
    }

    private float getDifference(Color sC, Color tC) {
        int dR = sC.getRed() - tC.getRed();
        int dB = sC.getBlue() - tC.getBlue();
        int dG = sC.getGreen() - tC.getGreen();
        return (float)Math.sqrt(dR * dR + dB * dB + dG * dG);
    }

    private float getDifference(int eX, int eY) {
        Color sC = new Color(this.source.getRGB(eX, eY), true);
        Color tC = new Color(this.target.getRGB(eX, eY), true);
        Color wC = new Color(this.writtenArea.getRGB(eX, eY));
        float difference = wC.equals(Color.black) ? 2.1474836E9f : this.getDifference(sC, tC);
        return difference;
    }

    private SobelVector getGradientVector(Point2D.Float pos) {
        return this.sobelVector[(int)pos.y * this.source.getWidth() + (int)pos.x];
    }

    private float getGradientMagnitude(Point2D.Float pos) {
        SobelVector sv = this.getGradientVector(pos);
        return (float)Math.sqrt(sv.x * sv.x + sv.y * sv.y);
    }

    private Point2D.Float getGradientDirection(Point2D.Float pos) {
        SobelVector sv = this.getGradientVector(pos);
        Point2D.Float gradient = new Point2D.Float(sv.x, sv.y);
        gradient.x /= this.getGradientMagnitude(pos);
        gradient.y /= this.getGradientMagnitude(pos);
        return gradient;
    }

    public BufferedImage getTargetImage() {
        return this.target;
    }

    public void setPredefinedStyle(PainterlyStyle newStyle) {
        this.painterlyStyle = new PainterlyStyle(newStyle);
    }

    public void setMaximumBrushSize(int newValue) {
        this.painterlyStyle.setMaximumBrushSize(newValue);
    }

    public int getMaximumBrushSize() {
        return this.painterlyStyle.getMaximumBrushSize();
    }

    public void setColorOpacity(int newValue) {
        this.painterlyStyle.setColorOpacity(newValue);
    }

    public int getColorOpacity() {
        return this.painterlyStyle.getColorOpacity();
    }

    public void setBlurFactor(float newValue) {
        this.painterlyStyle.setBlurFactor(newValue);
    }

    public float getBlurFactor() {
        return this.painterlyStyle.getBlurFactor();
    }

    public void setGridSize(float newValue) {
        this.painterlyStyle.setGridSize(newValue);
    }

    public float getGridSize() {
        return this.painterlyStyle.getGridSize();
    }

    public void setCurvatureFilter(float newValue) {
        this.painterlyStyle.setCurvatureFilter(newValue);
    }

    public float getCurvatureFilter() {
        return this.painterlyStyle.getCurvatureFilter();
    }

    public void setThreshold(float newValue) {
        this.painterlyStyle.setThreshold(newValue);
    }

    public float getThreshold() {
        return this.painterlyStyle.getThreshold();
    }

    public void setMinimumStrokeLength(int newValue) {
        this.painterlyStyle.setMinimumStrokeLength(newValue);
    }

    public int getMinimumStrokeLength() {
        return this.painterlyStyle.getMinimumStrokeLength();
    }

    public void setMaximumStrokeLength(int newValue) {
        this.painterlyStyle.setMaximumStrokeLength(newValue);
    }

    public int getMaximumStrokeLength() {
        return this.painterlyStyle.getMaximumStrokeLength();
    }

    public void setHueJitter(float newValue) {
        this.painterlyStyle.setHueJitter(newValue);
    }

    public float getHueJitter() {
        return this.painterlyStyle.getHueJitter();
    }

    public void setSaturationJitter(float newValue) {
        this.painterlyStyle.setSaturationJitter(newValue);
    }

    public float getSaturationJitter() {
        return this.painterlyStyle.getSaturationJitter();
    }

    public void setValueJitter(float newValue) {
        this.painterlyStyle.setValueJitter(newValue);
    }

    public float getValueJitter() {
        return this.painterlyStyle.getValueJitter();
    }

    public void setRedJitter(float newValue) {
        this.painterlyStyle.setValueJitter(newValue);
    }

    public float getRedJitter() {
        return this.painterlyStyle.getRedJitter();
    }

    public void setGreenJitter(float newValue) {
        this.painterlyStyle.setGreenJitter(newValue);
    }

    public float getGreenJitter() {
        return this.painterlyStyle.getGreenJitter();
    }

    public void setBlueJitter(float newValue) {
        this.painterlyStyle.setBlueJitter(newValue);
    }

    public float getBlueJitter() {
        return this.painterlyStyle.getBlueJitter();
    }

    public void setDrawEdges(boolean newValue) {
        this.painterlyStyle.setDrawEdges(newValue);
    }

    public boolean getDrawEdges() {
        return this.painterlyStyle.getDrawEdges();
    }

    public void setEdgeThreshold(float newValue) {
        this.painterlyStyle.setEdgeThreshold(newValue);
    }

    public float getEdgeThreshold() {
        return this.painterlyStyle.getEdgeThreshold();
    }

    public void addStateChangeListener(StateChangeListener l) {
        this._stateChangeListeners.add(l);
    }

    protected void fireStateChangeEvent() {
        Iterator<StateChangeListener> it = this._stateChangeListeners.iterator();
        while (it.hasNext()) {
            it.next().stateChanged();
        }
    }

    private class SobelVector {
        public short x;
        public short y;

        private SobelVector() {
        }
    }
}

