/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.TransferFilter;

public class CurvesFilter
extends TransferFilter {
    private Curve[] curves = new Curve[3];

    public CurvesFilter() {
        this.curves[0] = new Curve();
        this.curves[1] = new Curve();
        this.curves[2] = new Curve();
    }

    @Override
    protected void initialize() {
        this.initialized = true;
        if (this.curves.length == 1) {
            this.bTable = this.curves[0].makeTable();
            this.gTable = this.bTable;
            this.rTable = this.bTable;
        } else {
            this.rTable = this.curves[0].makeTable();
            this.gTable = this.curves[1].makeTable();
            this.bTable = this.curves[2].makeTable();
        }
    }

    public void setCurve(Curve curve) {
        this.curves = new Curve[]{curve};
        this.initialized = false;
    }

    public void setCurves(Curve[] curves) {
        if (curves == null || curves.length != 1 && curves.length != 3) {
            throw new IllegalArgumentException("Curves must be length 1 or 3");
        }
        this.curves = curves;
        this.initialized = false;
    }

    public Curve[] getCurves() {
        return this.curves;
    }

    public String toString() {
        return "Colors/Curves...";
    }

    public static class Curve {
        public float[] x;
        public float[] y;

        public Curve() {
            this.x = new float[]{0.0f, 1.0f};
            this.y = new float[]{0.0f, 1.0f};
        }

        public Curve(Curve curve) {
            this.x = (float[])curve.x.clone();
            this.y = (float[])curve.y.clone();
        }

        public int addKnot(float kx, float ky) {
            int pos = -1;
            int numKnots = this.x.length;
            float[] nx = new float[numKnots + 1];
            float[] ny = new float[numKnots + 1];
            int j = 0;
            int i = 0;
            while (i < numKnots) {
                if (pos == -1 && this.x[i] > kx) {
                    pos = j;
                    nx[j] = kx;
                    ny[j] = ky;
                    ++j;
                }
                nx[j] = this.x[i];
                ny[j] = this.y[i];
                ++j;
                ++i;
            }
            if (pos == -1) {
                pos = j;
                nx[j] = kx;
                ny[j] = ky;
            }
            this.x = nx;
            this.y = ny;
            return pos;
        }

        public void removeKnot(int n) {
            int numKnots = this.x.length;
            if (numKnots <= 2) {
                return;
            }
            float[] nx = new float[numKnots - 1];
            float[] ny = new float[numKnots - 1];
            int j = 0;
            int i = 0;
            while (i < numKnots - 1) {
                if (i == n) {
                    ++j;
                }
                nx[i] = this.x[j];
                ny[i] = this.y[j];
                ++j;
                ++i;
            }
            this.x = nx;
            this.y = ny;
            i = 0;
            while (i < this.x.length) {
                System.out.println(String.valueOf(i) + ": " + this.x[i] + " " + this.y[i]);
                ++i;
            }
        }

        private void sortKnots() {
            int numKnots = this.x.length;
            int i = 1;
            while (i < numKnots - 1) {
                int j = 1;
                while (j < i) {
                    if (this.x[i] < this.x[j]) {
                        float t = this.x[i];
                        this.x[i] = this.x[j];
                        this.x[j] = t;
                        t = this.y[i];
                        this.y[i] = this.y[j];
                        this.y[j] = t;
                    }
                    ++j;
                }
                ++i;
            }
        }

        protected int[] makeTable() {
            int numKnots = this.x.length;
            float[] nx = new float[numKnots + 2];
            float[] ny = new float[numKnots + 2];
            System.arraycopy(this.x, 0, nx, 1, numKnots);
            System.arraycopy(this.y, 0, ny, 1, numKnots);
            nx[0] = nx[1];
            ny[0] = ny[1];
            nx[numKnots + 1] = nx[numKnots];
            ny[numKnots + 1] = ny[numKnots];
            int[] table = new int[256];
            int i = 0;
            while (i < 1024) {
                float f = (float)i / 1024.0f;
                int x = (int)(255.0f * ImageMath.spline(f, nx.length, nx) + 0.5f);
                int y = (int)(255.0f * ImageMath.spline(f, nx.length, ny) + 0.5f);
                x = ImageMath.clamp(x, 0, 255);
                table[x] = y = ImageMath.clamp(y, 0, 255);
                ++i;
            }
            return table;
        }
    }
}

