/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PainterlyFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Document _document = new Document();
    private String[] styleDescriptions = new String[]{"Impressionist", "Expressionist", "Colorist Wash", "Pointillist"};
    private JComboBox predefinedStyles;
    private JSlider maxBrushSize;
    private JSlider colorOpacity;
    private JSlider minStrokeLength;
    private JSlider maxStrokeLength;
    private JSlider blurFactor;
    private JSlider gridSize;
    private JSlider curvature;
    private JSlider threshold;
    private JSlider hueJitter;
    private JSlider saturationJitter;
    private JSlider valueJitter;
    private JSlider redJitter;
    private JSlider greenJitter;
    private JSlider blueJitter;
    private JCheckBox drawEdges;
    private JSlider edgeThreshold;
    private JButton applyButton;
    private ActionListener onSelectSourceClick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            int result = chooser.showOpenDialog(PainterlyFrame.this);
            if (result != 0) {
                return;
            }
            PainterlyFrame.this._document.selectSourceFile(chooser.getSelectedFile().getAbsolutePath());
            PainterlyFrame.this.applyButton.setEnabled(true);
            PainterlyFrame.this.applyButton.doClick();
        }
    };
    private ActionListener onSaveClick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            int result = chooser.showSaveDialog(PainterlyFrame.this);
            if (result != 0) {
                return;
            }
            PainterlyFrame.this._document.saveDocument(chooser.getSelectedFile().getAbsolutePath());
        }
    };
    private ActionListener onExitClick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    };

    public PainterlyFrame() {
        super("CS798 Painterly Rendering Assignment");
        this.createLayout();
        this.setupMenu();
        this.setSize(new Dimension(800, 600));
        this.setDefaultCloseOperation(3);
    }

    private Component createBrushTab() {
        JPanel parametersFrame = new JPanel();
        parametersFrame.setLayout(new GridLayout(4, 2));
        parametersFrame.setBorder(this.createEmptyBorder());
        this.maxBrushSize = new JSlider(2, 32, this._document.getMaximumBrushSize());
        this.maxBrushSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setMaximumBrushSize(PainterlyFrame.this.maxBrushSize.getValue());
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Max Brush Size: "));
        parametersFrame.add(this.maxBrushSize);
        this.minStrokeLength = new JSlider(0, 40, this._document.getMinimumStrokeLength());
        this.minStrokeLength.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setMinimumStrokeLength(PainterlyFrame.this.minStrokeLength.getValue());
                if (PainterlyFrame.this.minStrokeLength.getValue() > PainterlyFrame.this.maxStrokeLength.getValue()) {
                    PainterlyFrame.this.maxStrokeLength.setValue(PainterlyFrame.this.minStrokeLength.getValue());
                }
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Min Stroke Length: "));
        parametersFrame.add(this.minStrokeLength);
        this.maxStrokeLength = new JSlider(0, 40, this._document.getMaximumStrokeLength());
        this.maxStrokeLength.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setMaximumStrokeLength(PainterlyFrame.this.maxStrokeLength.getValue());
                if (PainterlyFrame.this.maxStrokeLength.getValue() < PainterlyFrame.this.minStrokeLength.getValue()) {
                    PainterlyFrame.this.minStrokeLength.setValue(PainterlyFrame.this.maxStrokeLength.getValue());
                }
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Max Stroke Length: "));
        parametersFrame.add(this.maxStrokeLength);
        this.curvature = new JSlider(0, 100, (int)(this._document.getCurvatureFilter() * 100.0f));
        this.curvature.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setCurvatureFilter((float)PainterlyFrame.this.curvature.getValue() / 100.0f);
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Stroke Curvature: "));
        parametersFrame.add(this.curvature);
        return parametersFrame;
    }

    private Component createStyleTab() {
        JPanel parametersFrame = new JPanel();
        parametersFrame.setLayout(new GridLayout(5, 2));
        parametersFrame.setBorder(this.createEmptyBorder());
        this.blurFactor = new JSlider(0, 100, (int)(this._document.getBlurFactor() * 100.0f));
        this.blurFactor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setBlurFactor((float)PainterlyFrame.this.blurFactor.getValue() / 100.0f);
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Blur Factor: "));
        parametersFrame.add(this.blurFactor);
        this.gridSize = new JSlider(0, 100, (int)(this._document.getGridSize() * 100.0f));
        this.gridSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setGridSize((float)PainterlyFrame.this.gridSize.getValue() / 100.0f);
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Grid Size: "));
        parametersFrame.add(this.gridSize);
        this.threshold = new JSlider(100, 3000, (int)(this._document.getThreshold() * 10.0f));
        this.threshold.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setThreshold((float)PainterlyFrame.this.threshold.getValue() / 10.0f);
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Painting Accuracy: "));
        parametersFrame.add(this.threshold);
        this.drawEdges = new JCheckBox("Trace Edges", this._document.getDrawEdges());
        this.drawEdges.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PainterlyFrame.this._document.setDrawEdges(true);
                } else {
                    PainterlyFrame.this._document.setDrawEdges(false);
                }
                PainterlyFrame.this.edgeThreshold.setEnabled(PainterlyFrame.this._document.getDrawEdges());
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(this.drawEdges);
        parametersFrame.add(new JLabel());
        this.edgeThreshold = new JSlider(0, 100, (int)this._document.getEdgeThreshold());
        this.edgeThreshold.setEnabled(this._document.getDrawEdges());
        this.edgeThreshold.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setEdgeThreshold(PainterlyFrame.this.edgeThreshold.getValue());
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Edge Threshold: "));
        parametersFrame.add(this.edgeThreshold);
        return parametersFrame;
    }

    private Component createColorTab() {
        JPanel parametersFrame = new JPanel();
        parametersFrame.setLayout(new GridLayout(7, 2));
        parametersFrame.setBorder(this.createEmptyBorder());
        this.colorOpacity = new JSlider(0, 255, this._document.getColorOpacity());
        this.colorOpacity.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setColorOpacity(PainterlyFrame.this.colorOpacity.getValue());
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Color Opacity: "));
        parametersFrame.add(this.colorOpacity);
        this.hueJitter = new JSlider(0, 10, (int)(this._document.getHueJitter() * 10.0f));
        this.hueJitter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setHueJitter((float)PainterlyFrame.this.hueJitter.getValue() / 10.0f);
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Hue Jittering: "));
        parametersFrame.add(this.hueJitter);
        this.saturationJitter = new JSlider(0, 10, (int)(this._document.getSaturationJitter() * 10.0f));
        this.saturationJitter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setSaturationJitter((float)PainterlyFrame.this.saturationJitter.getValue() / 10.0f);
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Saturation Jittering: "));
        parametersFrame.add(this.saturationJitter);
        this.valueJitter = new JSlider(0, 10, (int)(this._document.getValueJitter() * 10.0f));
        this.valueJitter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setValueJitter((float)PainterlyFrame.this.valueJitter.getValue() / 10.0f);
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Value Jittering: "));
        parametersFrame.add(this.valueJitter);
        this.redJitter = new JSlider(0, 10, (int)(this._document.getRedJitter() * 10.0f));
        this.redJitter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setRedJitter((float)PainterlyFrame.this.redJitter.getValue() / 10.0f);
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Red Jittering: "));
        parametersFrame.add(this.redJitter);
        this.greenJitter = new JSlider(0, 10, (int)(this._document.getGreenJitter() * 10.0f));
        this.greenJitter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setGreenJitter((float)PainterlyFrame.this.greenJitter.getValue() / 10.0f);
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Green Jittering: "));
        parametersFrame.add(this.greenJitter);
        this.blueJitter = new JSlider(0, 10, (int)(this._document.getBlueJitter() * 10.0f));
        this.blueJitter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainterlyFrame.this._document.setBlueJitter((float)PainterlyFrame.this.blueJitter.getValue() / 10.0f);
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        parametersFrame.add(new JLabel("Blue Jittering: "));
        parametersFrame.add(this.blueJitter);
        return parametersFrame;
    }

    private Border createEmptyBorder() {
        return BorderFactory.createEmptyBorder(3, 3, 3, 3);
    }

    private Component createToolbox() {
        JPanel toolboxFrame = new JPanel();
        toolboxFrame.setLayout(new BorderLayout());
        toolboxFrame.setBorder(this.createEmptyBorder());
        this.predefinedStyles = new JComboBox();
        this.predefinedStyles.setEditable(false);
        int i = 0;
        while (i < this.styleDescriptions.length) {
            this.predefinedStyles.addItem(this.styleDescriptions[i]);
            ++i;
        }
        this.predefinedStyles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                switch (PainterlyFrame.this.predefinedStyles.getSelectedIndex()) {
                    case 0: {
                        PainterlyFrame.this._document.setPredefinedStyle(PainterlyStyle.IMPRESSIONIST_STYLE);
                        break;
                    }
                    case 1: {
                        PainterlyFrame.this._document.setPredefinedStyle(PainterlyStyle.EXPRESSIONIST_STYLE);
                        break;
                    }
                    case 2: {
                        PainterlyFrame.this._document.setPredefinedStyle(PainterlyStyle.COLORISTWASH_STYLE);
                        break;
                    }
                    case 3: {
                        PainterlyFrame.this._document.setPredefinedStyle(PainterlyStyle.POINTILLIST_STYLE);
                    }
                }
                PainterlyFrame.this.loadToolboxValuesFromDocument();
                PainterlyFrame.this.applyButton.setEnabled(true);
            }
        });
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new GridLayout(1, 2));
        northPanel.setBorder(this.createEmptyBorder());
        northPanel.add(new JLabel("Predefined Styles: "));
        northPanel.add(this.predefinedStyles);
        toolboxFrame.add((Component)northPanel, "North");
        this.applyButton = new JButton("Apply Parameters");
        this.applyButton.setBorder(BorderFactory.createCompoundBorder(this.createEmptyBorder(), this.applyButton.getBorder()));
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PainterlyFrame.this.setCursor(new Cursor(3));
                PainterlyFrame.this._document.doPainterly();
                PainterlyFrame.this.setCursor(new Cursor(0));
                PainterlyFrame.this.applyButton.setEnabled(false);
            }
        });
        toolboxFrame.add((Component)this.applyButton, "South");
        JTabbedPane tabbedPane = PainterlyFrame.createTabbedPane(2);
        PainterlyFrame.addTab(tabbedPane, "Brush Properties", this.createBrushTab());
        PainterlyFrame.addTab(tabbedPane, "Painting Style Properties", this.createStyleTab());
        PainterlyFrame.addTab(tabbedPane, "Color Properties", this.createColorTab());
        toolboxFrame.add((Component)tabbedPane, "Center");
        return toolboxFrame;
    }

    private void loadToolboxValuesFromDocument() {
        this.maxBrushSize.setValue(this._document.getMaximumBrushSize());
        this.colorOpacity.setValue(this._document.getColorOpacity());
        this.minStrokeLength.setValue(this._document.getMinimumStrokeLength());
        this.maxStrokeLength.setValue(this._document.getMaximumStrokeLength());
        this.blurFactor.setValue((int)(this._document.getBlurFactor() * 100.0f));
        this.gridSize.setValue((int)(this._document.getGridSize() * 100.0f));
        this.curvature.setValue((int)(this._document.getCurvatureFilter() * 100.0f));
        this.threshold.setValue((int)(this._document.getThreshold() * 10.0f));
        this.hueJitter.setValue((int)(this._document.getHueJitter() * 10.0f));
        this.saturationJitter.setValue((int)(this._document.getSaturationJitter() * 10.0f));
        this.valueJitter.setValue((int)(this._document.getValueJitter() * 10.0f));
        this.redJitter.setValue((int)(this._document.getRedJitter() * 10.0f));
        this.greenJitter.setValue((int)(this._document.getGreenJitter() * 10.0f));
        this.blueJitter.setValue((int)(this._document.getBlueJitter() * 10.0f));
        this.drawEdges.setSelected(this._document.getDrawEdges());
        this.edgeThreshold.setValue((int)this._document.getEdgeThreshold());
    }

    private void createLayout() {
        this.getContentPane().add(this.createToolbox(), "West");
        this.getContentPane().add((Component)new JScrollPane(new PainterlyPanel(this._document)), "Center");
        this.getContentPane().validate();
    }

    private void setupMenu() {
        JMenuBar menu = new JMenuBar();
        JMenu imageMenu = new JMenu("Image");
        JMenuItem selectSourceMI = new JMenuItem("Select Source...");
        selectSourceMI.addActionListener(this.onSelectSourceClick);
        imageMenu.add(selectSourceMI);
        JMenuItem saveMI = new JMenuItem("Save...");
        saveMI.addActionListener(this.onSaveClick);
        imageMenu.add(saveMI);
        JMenuItem exitMI = new JMenuItem("Exit");
        exitMI.addActionListener(this.onExitClick);
        imageMenu.add(exitMI);
        menu.add(imageMenu);
        this.setJMenuBar(menu);
    }

    public static JTabbedPane createTabbedPane(int tabPlacement) {
        switch (tabPlacement) {
            case 2: 
            case 4: {
                Object textIconGap = UIManager.get("TabbedPane.textIconGap");
                Insets tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
                UIManager.put("TabbedPane.textIconGap", new Integer(1));
                UIManager.put("TabbedPane.tabInsets", new Insets(tabInsets.left, tabInsets.top, tabInsets.right, tabInsets.bottom));
                JTabbedPane tabPane = new JTabbedPane(tabPlacement);
                UIManager.put("TabbedPane.textIconGap", textIconGap);
                UIManager.put("TabbedPane.tabInsets", tabInsets);
                return tabPane;
            }
        }
        return new JTabbedPane(tabPlacement);
    }

    public static void addTab(JTabbedPane tabPane, String text, Component comp) {
        int tabPlacement = tabPane.getTabPlacement();
        switch (tabPlacement) {
            case 2: 
            case 4: {
                tabPane.addTab(null, new VerticalTextIcon(text, tabPlacement == 4), comp);
                return;
            }
        }
        tabPane.addTab(text, null, comp);
    }
}

