# license : public domain

class Pdb:
	def __getattr__(self, name):
		import gi
		gi.require_version('Gimp', '3.0')
		from gi.repository import Gimp
		from gi.repository import GObject
		
		fuName = name.replace('_', '-')
		def pdbFunc(*args, fuName=fuName):
			params = list(map(lambda arg: GObject.Value(type(arg), arg), args))
			Gimp.get_pdb().run_procedure(fuName, params)
		return pdbFunc
pdb = Pdb()

def register(procedureName, blurb, help_message, author, copyright, year, label, imageTypes, arguments, returnValues, plugin_func, menuPath):
	import gi
	gi.require_version('Gimp', '3.0')
	from gi.repository import Gimp
	gi.require_version('GimpUi', '3.0')
	from gi.repository import GimpUi
	
	import sys
	
	class thePlugin(Gimp.PlugIn):
		__gproperties__ = arguments
		
		def do_query_procedures(self):
			return [ procedureName ]
		
		def do_create_procedure(self, name):
			procedure = Gimp.ImageProcedure.new(self, name, Gimp.PDBProcType.PLUGIN, self.run, None)

			procedure.set_image_types(imageTypes)
			procedure.set_menu_label(label)
			procedure.add_menu_path(menuPath)

			procedure.set_documentation(help_message,
										blurb,
										name)
			procedure.set_attribution(author, copyright, year)
			
			for propName in arguments:
				procedure.add_argument_from_property(self, propName)
			return procedure
		
		def run(self, procedure, run_mode, image, n_drawables, drawables, args, run_data):
			config = procedure.create_config()
			config.begin_run(image, run_mode, args)

			if run_mode == Gimp.RunMode.INTERACTIVE:

				GimpUi.init(__file__)

				dialog = GimpUi.ProcedureDialog(procedure=procedure, config=config)
				dialog.fill(None)
				if not dialog.run():
					return Gimp.ValueArray(0)
			
			parameters = {}
			for propName in arguments:
				parameters[propName] = config.get_property(propName)

			plugin_func(image, drawables, parameters)

			Gimp.displays_flush()

			config.end_run(Gimp.PDBStatusType.SUCCESS)
			return Gimp.ValueArray(0)
			
	Gimp.main(thePlugin.__gtype__, sys.argv)
